% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crplot.R
\name{crplot}
\alias{crplot}
\title{Plotting Two-Dimensional Confidence Regions}
\usage{
crplot(dataset, alpha, distn,
                heuristic = 1,
                maxdeg    = 5,
                ellipse_n = 4,
                pts       = TRUE,
                mlelab    = TRUE,
                sf        = c(5, 5),
                mar       = c(4, 4.5, 2, 1.5),
                xlab      = "",
                ylab      = "",
                main      = "",
                xlas      = 1,
                ylas      = 2,
                origin    = FALSE,
                xlim      = NULL,
                ylim      = NULL,
                tol       = .Machine$double.eps ^ 0.5,
                info      = FALSE,
                showplot  = TRUE )
}
\arguments{
\item{dataset}{a 1 x n vector of dataset values.}

\item{alpha}{significance level; resulting plot illustrates a 100(1 - alpha)\% confidence region.}

\item{distn}{distribution to fit the dataset to; accepted values: \code{"weibull"}, \code{"invgauss"}.}

\item{heuristic}{numeric value selecting method for plotting: 0 for elliptic-oriented point distribution, and
1 for smoothing boundary search heuristic.}

\item{maxdeg}{maximum angle tolerance between consecutive plot segments in degrees.}

\item{ellipse_n}{number of roughly equidistant confidence region points to plot using the
elliptic-oriented point distribution (must be a multiple of four because its algorithm
exploits symmetry in the quadrants of an ellipse).}

\item{pts}{displays confidence region boundary points identified if \code{TRUE}.}

\item{mlelab}{logical argument to include the maximum
likelihood estimate coordinate point (default is \code{TRUE}).}

\item{sf}{specifies the number of significant figures on axes labels.}

\item{mar}{specifies margin values for \code{par(mar = c( ))} (see \code{mar} in \code{\link{par}}).}

\item{xlab}{string specifying the x axis label.}

\item{ylab}{string specifying the y axis label.}

\item{main}{string specifying the plot title.}

\item{xlas}{numeric in {0, 1, 2, 3} specifying the style of axis labels (see \code{las} in \code{\link{par}}).}

\item{ylas}{numeric in {0, 1, 2, 3} specifying the style of axis labels (see \code{las} in \code{\link{par}}).}

\item{origin}{logical argument to include the plot origin (default is \code{FALSE}).}

\item{xlim}{two element vector containing horizontal axis minimum and maximum values.}

\item{ylim}{two element vector containing vertical axis minimum and maximum values.}

\item{tol}{the \code{\link{uniroot}} parameter specifying its required accuracy.}

\item{info}{logical argument to return plot information: MLE prints to screen; (x, y) plot point coordinates
and corresponding phi angles (with respect to MLE) are returned as a list.}

\item{showplot}{logical argument specifying if a plot is output; altering from its default of \code{TRUE} is
only logical assuming \code{crplot} is run for its data only (see the \code{info} argument).}
}
\value{
if the optional argument \code{info = TRUE} is included then a list of plot coordinates and phi angles is returned
}
\description{
Plots the two-dimensional confidence region for probability distribution (Weibull or
inverse Gaussian) parameters corresponding to a user given dataset and level of significance.
}
\details{
This function supports two-dimensional confidence region plots for Weibull or inverse Gaussian parameters.
The first input argument (shape for Weibull, mean for inverse Gaussian) is given on its horizontal axis,
and the second (scale for Weibull, shape for inverse Gaussian) on the vertical axis.  It requires
\itemize{
\item a vector of dataset values,
\item the level of significance (alpha), and
\item a distribution (Weibull or inverse Gaussian) to fit the data to.
}
Two heuristics (and their associated combination) are available to plot confidence regions.  Along
with their descriptions, they are:
\enumerate{
\item \emph{Smoothing Boundary Search Heuristic (default)}.  This heuristic plots more points in areas of
greater curvature to ensure a smooth appearance throughout the confidence region boundary.  Its
\code{maxdeg} parameter specifies the maximum tolerable angle between three successive points.
Lower values of \code{maxdeg} result in smoother plots, and its default value of 5 degrees
provides adequate smoothing in most circumstances.  Values of \code{maxdeg} \eqn{\le} 3 are not
permitted due to their complicating implications to trigonometric numerical approximations near 0
and 1.
\item \emph{Elliptic-Oriented Point Distribution}.  This heuristic allows the user to specify
a number of points to plot along the confidence region boundary at roughly uniform intervals.
Its name is derived from the technique it uses to choose these points---an extension of the Steiner
generation of a non-degenerate conic section, also known as the parallelogram method---which identifies
points along an ellipse that are approximately equidistant.  To exploit the computational benefits of
ellipse symmetry over its four quadrants, \code{ellipse_n} value must be divisible by four.}
By default, \code{crplot} implements the smoothing boundary search heuristic.  Alternatively,
the user can plot using the elliptic-oriented point distribution algorithm, or a combination
of them both.  Combining the two techniques initializes the plot using the elliptic-oriented point
distribution algorithm, and then subsequently populates additional points in areas of high curvature
(those outside of the maximum angle tolerance parameterization) in accordance with the smoothing
boundary search heuristic.  This combination results when the smoothing boundary search heuristic
is specified in conjunction with an \code{ellipse_n} value greater than four.

Both of the aforementioned heuristics use a radial profile log likelihood function to identify
points along the confidence region boundary.  It cuts the log likelihood function in a directional
azimuth from its MLE, and locates the associated confidence region boundary point using the
asymptotic results associated with the ratio test statistic \eqn{-2 [log L(\theta) - log L(\theta hat)]}
which converges in distribution to the chi-square distribution with two degrees of freedom (for
a two parameter distribution).
}
\examples{
## plot the 95\% confidence region for Weibull shape and scale parameters
## corresponding to the given ballbearing dataset
ballbearing <- c(17.88, 28.92, 33.00, 41.52, 42.12, 45.60, 48.48, 51.84,
                 51.96, 54.12, 55.56, 67.80, 68.64, 68.64, 68.88, 84.12,
                 93.12, 98.64, 105.12, 105.84, 127.92, 128.04, 173.40)
crplot(dataset = ballbearing, distn = "weibull", alpha = 0.05)

## repeat this plot using the elliptic-oriented point distribution heuristic
crplot(dataset = ballbearing, distn = "weibull", alpha = 0.05,
       heuristic = 0, ellipse_n = 80)

## combine the two heuristics, compensating any elliptic-oriented point verticies whose apparent
## angles > 6 degrees with additional points, and expand the plot area to include the origin
crplot(dataset = ballbearing, distn = "weibull", alpha = 0.05,
       maxdeg = 6, ellipse_n = 80, origin = TRUE)

## next use the inverse Gaussian distribution and show no plot points
crplot(dataset = ballbearing, distn = "invgauss", alpha = 0.05,
       pts = FALSE)
}
\seealso{
\code{\link{uniroot}}
}
\author{
Christopher Weld (\email{ceweld@email.wm.edu})

Lawrence Leemis (\email{leemis@math.wm.edu})
}
\keyword{Estimation,}
\keyword{Graphical}
\keyword{Methods,}
\keyword{Numerical}
\keyword{Optimization}
\keyword{Parameter}
\keyword{confidence}
\keyword{data}
\keyword{graphics,}
\keyword{intervals,}
\keyword{region,}
\keyword{statistical}
\keyword{visualization}
