% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\encoding{UTF-8}
\name{cor_covariance}
\alias{cor_covariance}
\title{Calculate the asymptotic sampling covariance matrix for the unique elements of a correlation matrix}
\usage{
cor_covariance(r, n)
}
\arguments{
\item{r}{A correlation matrix}

\item{n}{The sample size}
}
\value{
The asymptotic sampling covariance matrix
}
\description{
Calculate the asymptotic sampling covariance matrix for the unique elements of a correlation matrix
}
\examples{
cor_covariance(matrix(c(1, .2, .3, .2, 1, .3, .3, .3, 1), ncol = 3), 100)
}
\references{
Nel, D. G. (1985).
A matrix derivation of the asymptotic covariance matrix of sample correlation coefficients.
\emph{Linear Algebra and Its Applications, 67}, 137–145. \url{https://doi.org/10/c75jmg}
}
\author{
Based on an internal function from the \pkg{fungible} package by Niels Waller
}
