% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fungible.R
\encoding{UTF-8}
\name{fungible.cpa}
\alias{fungible.cpa}
\title{Locate extrema of fungible criterion profile patterns}
\usage{
\method{fungible}{cpa}(object, theta = 0.005, Nstarts = 1000,
  MaxMin = c("min", "max"), silent = FALSE, ...)
}
\arguments{
\item{object}{A fitted model object of class "cpa".}

\item{theta}{A vector of values to decrement from R-squared to compute families of fungible coefficients.}

\item{Nstarts}{Maximum number of (max) minimizations from random starting configurations.}

\item{MaxMin}{Should the cosine between the observed and alternative weights be maximized ("max") to find the maximally similar coefficients or minimized ("min") to find the maximally dissimilar coefficients?}

\item{silent}{Should current optimization values be printed to the console (\code{FALSE}) or suppressed (\code{TRUE})?}

\item{...}{Additional arguments}
}
\value{
A list containing the alternative weights and other fungible weights estimation parameters
}
\description{
Identify maximally similar or dissimilar criterion patterns in criterion profile analysis
}
\examples{
mind <- cpa_mat(mindfulness ~ ES + A + C + Ex + O,
                cov_mat = mindfulness$r,
                n = harmonic_mean(vechs(mindfulness$n)),
                se_var_mat = cor_covariance_meta(mindfulness$r,
                                                 mindfulness$n,
                                                 mindfulness$sevar_r,
                                                 mindfulness$source),
                adjust = "pop")
mind_fung <- fungible(mind, Nstarts = 100)
}
\references{
Wiernik, B. M., Wilmot, M. P., Davison, M. L., & Ones, D. S. (2019).
\emph{Meta-analytic criterion profile analysis}.
Manuscript submitted for publication, University of South Florida.
}
