% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ci_oddsratio.R
\name{ci_oddsratio}
\alias{ci_oddsratio}
\title{Confidence Interval for the Odds Ratio}
\usage{
ci_oddsratio(x, probs = c(0.025, 0.975))
}
\arguments{
\item{x}{A 2x2 \code{table/matrix} of frequencies, or a \code{data.frame} with exactly two columns.}

\item{probs}{Error probabilites. The default c(0.025, 0.975) gives a symmetric 95\% confidence interval.}
}
\value{
A list with class \code{cint} containing these components:
\itemize{
\item \code{parameter}: The parameter in question.
\item \code{interval}: The confidence interval for the parameter.
\item \code{estimate}: The estimate for the parameter.
\item \code{probs}: A vector of error probabilities.
\item \code{type}: The type of the interval.
\item \code{info}: An additional description text for the interval.
}
}
\description{
This function calculates a confidence interval for the odds ratio in a 2x2 table/matrix or a data frame with two columns. The confidence interval is obtained through \code{stats::fisher.test}. Bootstrap confidence intervals are not available.
}
\examples{
x <- cbind(c(10, 5), c(4, 4))
ci_oddsratio(x)
}
\seealso{
\code{\link{oddsratio}}.
}
