% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.multidim.R
\name{plot_multidim}
\alias{plot_multidim}
\title{Plot Confidence Regions obtained with Split Conformal}
\usage{
plot_multidim(out, same.scale = FALSE)
}
\arguments{
\item{out}{The output of a prediction function.}

\item{same.scale}{Should I force the same scale for all the y-axis ? Default
is FALSE.}
}
\value{
g_list A list of ggplots (output[[i]] is the i-th observation confidence region).
}
\description{
Plot Confidence Regions obtained with Split Conformal
}
\details{
It exploits the package \code{\link{ggplot2}}, \code{\link{gridExtra}}
and \code{\link{hrbrthemes}} to better visualize the results.
}
\examples{
n=50
p=4
q=2

mu=rep(0,p)
x = mvtnorm::rmvnorm(n, mu)
beta<-sapply(1:q, function(k) c(mvtnorm::rmvnorm(1,mu)))
y = x\%*\%beta + t(mvtnorm::rmvnorm(q,1:n))
x0=x[ceiling(0.9*n):n,]
y0=y[ceiling(0.9*n):n,]

n0<-nrow(y0)
q<-ncol(y)

fun=mean_multi()

final.point = conformal.multidim.split(x,y,x0, fun$train.fun, fun$predict.fun,
                             alpha=0.1,
                                split=NULL, seed=FALSE, randomized=FALSE,seed.rand=FALSE,
                                verbose=FALSE, rho=0.5,score ="l2",s.type="st-dev")

ppp2<-plot_multidim(final.point)

n=25
p=4
q=2


mu=rep(0,p)
x = mvtnorm::rmvnorm(n, mu)
beta<-sapply(1:q, function(k) c(mvtnorm::rmvnorm(1,mu)))
y = x\%*\%beta + t(mvtnorm::rmvnorm(q,1:n))
x0=x[ceiling(0.9*n):n,]
y0=y[ceiling(0.9*n):n,]

n0<-nrow(y0)
q<-ncol(y)


fun=mean_multi()

#################################### FULL CONFORMAL

final.full=conformal.multidim.full(x, y, x0, fun$train.fun,
                                fun$predict.fun, score="l2",
                                num.grid.pts.dim=5, grid.factor=1.25,
                                verbose=FALSE)

ppp<-plot_multidim(final.full)

}
