% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/committee.R
\name{cong_committee}
\alias{cong_committee}
\title{Request Committee Information}
\usage{
cong_committee(
  congress = NULL,
  chamber = NULL,
  committee = NULL,
  item = NULL,
  from_date = NULL,
  to_date = NULL,
  limit = 20,
  offset = 0,
  format = "json",
  clean = TRUE
)
}
\arguments{
\item{congress}{Congress number to search for. 81 or later are supported.}

\item{chamber}{Chamber name. Can be \code{'house'}, \code{'senate'}, or \code{'joint'}.}

\item{committee}{Code identifying committee. Character.}

\item{item}{Information to request. Can be \code{'bills'}, \code{'reports'}, or \code{'nominations'}.}

\item{from_date}{start date for search, e.g. \code{'2022-04-01'}. Defaults to most recent.}

\item{to_date}{end date for search, e.g. \code{'2022-04-03'}. Defaults to most recent.}

\item{limit}{number of records to return. Default is 20. Will be truncated to between 1 and 250.}

\item{offset}{number of records to skip. Default is 0. Must be non-negative.}

\item{format}{Output format for \code{clean = FALSE}. One of \code{xml} or \code{json}.}

\item{clean}{Default is TRUE. Should output be returned as a \code{tibble} (\code{TRUE}) or requested \code{format}.}
}
\value{
\code{tibble} or HTTP response if \code{clean = FALSE}
}
\description{
Request Committee Information
}
\examples{
\dontshow{if (congress::has_congress_key()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Requires API Key

cong_committee()

cong_committee(congress = 117)

cong_committee(chamber = 'house')

cong_committee(congress = 117, chamber = 'house')

cong_committee(chamber = 'house', committee = 'hspw00')

cong_committee(chamber = 'senate', committee = 'ssas00', item = 'bills')
\dontshow{\}) # examplesIf}
}
