% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sen_senator_list.R
\name{sen_senator_legis}
\alias{sen_senator_legis}
\title{Downloads and tidies information on the senators in the Federal Senate}
\usage{
sen_senator_legis(start = NULL, end = NULL, state = NULL, status = NULL,
  ascii = TRUE)
}
\arguments{
\item{start}{two-digit integer representing the first legislature of the
time period requested.}

\item{end}{two-digit integer representing the final legislature of the time
period requested.}

\item{state}{\code{character}. Two-letter abbreviation of Brazilian state. A list of these is
available with the function \code{UF()}.}

\item{status}{\code{character}, either "T" or "S", representing
\emph{titular} or \emph{suplente} (stand-in senator), respectively.}

\item{ascii}{\code{logical}. If \code{TRUE}, strips Latin characters from
strings.}
}
\value{
A tibble, of classes \code{tbl_df}, \code{tbl} and \code{data.frame}.
}
\description{
Downloads and tidies information on the senators in the Federal Senate.
}
\examples{
all <- sen_senator_legis(start = 50)
}
\author{
Robert Myles McDonnell, Guilherme Jardim Duarte & Danilo Freire.
}
