% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sen_senator.R
\name{sen_senator}
\alias{sen_senator}
\title{Downloads and tidies persnonal information on senators from the
Federal Senate}
\usage{
sen_senator(id = NULL, affiliations = TRUE, mandates = TRUE,
  absences = FALSE, ascii = TRUE)
}
\arguments{
\item{id}{\code{integer}. Unique id for a senator. A dataframe of these
is available from \code{sen_senator_list()}.}

\item{affiliations}{\code{logical}. If TRUE, the default, returns information
on party affiliation.}

\item{mandates}{\code{logical}. If TRUE, the default, returns information on
terms served by the senator.}

\item{absences}{\code{logical}. If TRUE, returns information on leaves of
absence taken by the senator.}

\item{ascii}{\code{logical}. If TRUE, certain strings are converted to ascii
format.}
}
\value{
A tibble, of classes \code{tbl_df}, \code{tbl} and \code{data.frame}.
}
\description{
Downloads and tidies persnonal information on senators from the
Federal Senate.
}
\note{
Setting \code{affiliations}, \code{mandates} and particularly
\code{absences} to \code{TRUE} will result in a rather bloated data frame.
}
\examples{
\dontrun{
benedito <- sen_senator(id = 3823)
aecio <- sen_senator(id = 391, absences = TRUE)
juc <- sen_senator(73)
}
}
\author{
Robert Myles McDonnell, Guilherme Jardim Duarte & Danilo Freire.
}
