% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sen_commission_list.R
\name{sen_commissions_type}
\alias{sen_commissions_type}
\title{Information on commissions in the Federal Senate, by commission type}
\usage{
sen_commissions_type(type = c("permanent", "cpi", "temporary"), ascii = TRUE)
}
\arguments{
\item{type}{\code{character}. Options are permanent, cpi and temporary.See details.}

\item{ascii}{\code{logical}. If TRUE, certain strings are converted to ascii
format.}
}
\value{
A tibble, of classes \code{tbl_df}, \code{tbl} and \code{data.frame}.
}
\description{
Information on commissions in the Federal Senate, by commission type.
}
\details{
Returns a data frame with the following variables:
\itemize{
 \item{\code{commission_id: }}{unique code for each commission.}
 \item{\code{commission_name: }}{name of the commission.}
 \item{\code{commission_type: }}{permanent commission, temporary, or a parliamentary inquiry \emph{Comissão Parlamentar de Inquérito}.}
 \item{\code{commission_house: }}{Legislative house where the commission is based.}
 \item{\code{active: }}{Whether the commission is active or not.}
}
}
\examples{
cpi <- sen_commissions_type(type = "permanent")
}
\author{
Robert Myles McDonnell, Guilherme Jardim Duarte & Danilo Freire.
}
