% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.latex.R
\name{read.latex}
\alias{read.latex}
\title{A function for reading LaTeX files}
\usage{
read.latex(file, filepath)
}
\arguments{
\item{file}{is the name of a file with .tex extension. The .tex file must be generated by R Sweave using package 'knitr'.}

\item{filepath}{is the absolute filepath where .tex file is located.}
}
\value{
\code{read.latex} returns two character strings: tex and path, both of which are used by \code{write.rtf}.
}
\description{
A function for reading LaTeX files
}
\examples{
#Read a sample LaTeX file
file<-'connect3-minimal.tex'
filepath<-paste(sub("examples/.*","\\\\1",
          system.file("examples","connect3-minimal.tex",package="connect3")),
          "examples", sep='')
obj<-read.latex(file, filepath)
obj$tex
obj$path
}
\seealso{
\code{\link{write.rtf}}
}

