% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateHelpers.R
\name{simplef}
\alias{simplef}
\title{simplef}
\usage{
simplef(theta, params)
}
\arguments{
\item{theta}{a scalar value of theta.}

\item{params}{an item design matrix that is of size response categories (k) by three. The three columns are:
* column one is scoring values, usually from 0 to k.
* column two is the delta dot parameter repeated k times
* column three is the tau parameter where for k = 1, tau = 0, and for k > 2, subsequent entries are deviations from delta dot.}
}
\value{
a double - the expected score at theta.
}
\description{
returns expected score at a given value of theta.
}
\examples{
myTheta<- 0
myDelta<- 1.5
x<- 2
k <- 3
itemParamX<- seq(0, k-1, 1)
itemParamD<- rep(myDelta, k)
itemParamT<- c(0, -0.5, 0.5)
itemParam<- cbind(itemParamX, itemParamD, itemParamT)
colnames(itemParam)<- c("x", "d", "t")
myExpect<- simplef(myTheta, itemParam)
}
\keyword{internal}
