% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/consort_functions.R
\name{consort_from_metadata}
\alias{consort_from_metadata}
\title{Function to generate consort diagrams}
\usage{
consort_from_metadata(metadata, data)
}
\arguments{
\item{metadata}{Metadata downloaded from shiny app}

\item{data}{Data uploaded to the app for generating consort diagram}
}
\value{
graph created by DiagrammeR (graph object of class dgr_graph)
}
\description{
Function to generate consort diagrams
}
\examples{
data <- data.frame(a = c('m', 'm', 'n', 'n'), 
                   b = c('p', 'p', 'q', 'q'))
metadata <- data.frame(label = c('All', "a=='m'"), 
                       code = c(TRUE, "a=='m'"), 
                       parent = c(0, 1), 
                       color = c("black", "black"), 
                       hidden = c(FALSE, FALSE), 
                       split_var = c('a', NA))
consort_diagram <- consort_from_metadata(metadata, data)

}
