% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/construct_diff.R
\name{construct_diff}
\alias{construct_diff}
\title{Display diff of object definitions}
\usage{
construct_diff(
  target,
  current,
  ...,
  data = NULL,
  pipe = NULL,
  check = TRUE,
  compare = compare_options(),
  one_liner = FALSE,
  template = getOption("constructive_opts_template"),
  mode = c("sidebyside", "auto", "unified", "context"),
  interactive = TRUE
)
}
\arguments{
\item{target}{the reference object}

\item{current}{the object being compared to \code{target}}

\item{...}{Constructive options built with the \verb{opts_*()} family of functions. See the "Constructive options"
section below.}

\item{data}{Named list or environment of objects we want to detect and mention by name (as opposed to
deparsing them further). Can also contain unnamed nested lists, environments, or
package names, in the latter case package exports and datasets will be considered.
In case of conflict, the last provided name is considered.}

\item{pipe}{Which pipe to use, either \code{"base"} or \code{"magrittr"}.
Defaults to \code{"base"} for R >= 4.2, otherwise to \code{"magrittr"}.}

\item{check}{Boolean. Whether to check if the created code reproduces the object
using \code{waldo::compare()}.}

\item{compare}{Parameters passed to \code{waldo::compare()}, built with \code{compare_options()}.}

\item{one_liner}{Boolean. Whether to collapse the output to a single line of code.}

\item{template}{A list of constructive options built with \verb{opts_*()} functions,
they will be overriden by \code{...}. Use it to set a default
behavior for \code{{constructive}}.}

\item{mode, interactive}{passed to \code{diffobj::diffChr()}}
}
\value{
Returns \code{NULL} invisibly, called for side effects
}
\description{
Display diff of object definitions
}
\examples{
\dontrun{
# some object print the same though they're different
# `construct_diff()` shows how they differ :
df1 <- data.frame(a=1, b = "x")
df2 <- data.frame(a=1L, b = "x", stringsAsFactors = TRUE)
attr(df2, "some_attribute") <- "a value"
df1
df2
construct_diff(df1, df2)


# Those are made easy to compare
construct_diff(substr, substring)
construct_diff(month.abb, month.name)

# more examples borrowed from {waldo} package
construct_diff(c("a", "b", "c"), c("a", "B", "c"))
construct_diff(c("X", letters), c(letters, "X"))
construct_diff(list(factor("x")), list(1L))
construct_diff(df1, df2)
x <- list(a = list(b = list(c = list(structure(1, e = 1)))))
y <- list(a = list(b = list(c = list(structure(1, e = "a")))))
construct_diff(x, y)
}
}
