% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s7-S7-object.R
\name{opts_S7_object}
\alias{opts_S7_object}
\title{Constructive options for class 'S7_object'}
\usage{
opts_S7_object(constructor = c("S7_object", "next"), ...)
}
\arguments{
\item{constructor}{String. Name of the function used to construct the object.}

\item{...}{Additional options used by user defined constructors through the \code{opts} object}
}
\value{
An object of class <constructive_options/constructive_options_S7_object>
}
\description{
These options will be used on objects of class 'S7_object'. This class is
unusual in that it can be applied on objects of different internal types,
objects of length 1 class \code{"S7_object"} are of type \code{"object"} while
for instance objects of class \code{c("S7_class", "S7_object")} are closures.
For closures we fall back to the next method.
}
\details{
Depending on \code{constructor}, we construct the object as follows:
\itemize{
\item \code{"S7_object"} (default): We build the object using \code{S7::S7_object()}.
\item \code{"next"} : Use the constructor for the next supported class.
}
}
