## ----knitr-setup, include = FALSE-----------------------------------------------------------------
require(container)
knitr::opts_chunk$set(
  comment = "#",
  prompt = F,
  tidy = FALSE,
  cache = FALSE,
  collapse = T
)

old <- options(width = 100L)

## -------------------------------------------------------------------------------------------------
library(container, warn.conflicts = FALSE)

# Define some parameters
params = dict(a = 1:10, b = "foo")

## ----error = TRUE---------------------------------------------------------------------------------
try({
params = add(params, a = 0)

add(params, x = 0) # ok
})

## -------------------------------------------------------------------------------------------------
replace_at(params, a = 0)

## ----error = TRUE---------------------------------------------------------------------------------
try({
replace_at(params, x = 0)
})

## ----error = TRUE---------------------------------------------------------------------------------
try({
replace_at(params, a = 0, .add=TRUE)

replace_at(params, x = 0, .add=TRUE)
})

## ----error = TRUE---------------------------------------------------------------------------------
try({
at(params, "x")

at(params, "a", "b")
})

## -------------------------------------------------------------------------------------------------
at2(params, "a")

## -------------------------------------------------------------------------------------------------
params["x"]

params[["x"]]

params["a"]

params[["a"]]

## -------------------------------------------------------------------------------------------------
peek_at(params, "x")

peek_at(params, "x", .default = 3:1)

## -------------------------------------------------------------------------------------------------
peek_at(params, "a", "x", "y", .default = 3:1)

## ----error = TRUE---------------------------------------------------------------------------------
try({
delete_at(params, "x")

delete_at(params, "a") # ok
})

## -------------------------------------------------------------------------------------------------
discard_at(params, "a", "x")

## -------------------------------------------------------------------------------------------------
params[["a"]] <- NULL

params

## -------------------------------------------------------------------------------------------------
par1 = dict(a = 1, b = "foo")
par2 = dict(b = "bar", x = 2, y = 3)

update(par1, par2)

## -------------------------------------------------------------------------------------------------
update(par1, as.dict(list(b = "my b", x = 100)))

## -------------------------------------------------------------------------------------------------
d = dict(x = 1, z = 2, a = 3)
d

d[[1]]

d[2:3]

## ----include = FALSE----------------------------------------------------------
options(old)

