% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Pearson_LR_tests_cum_OR_2xc.R
\name{Pearson_LR_tests_cum_OR_2xc}
\alias{Pearson_LR_tests_cum_OR_2xc}
\title{The Pearson chi-squared and likelihood ratio tests for cumulative ORs in 2xc tables}
\usage{
Pearson_LR_tests_cum_OR_2xc(n, direction = "decreasing", printresults = TRUE)
}
\arguments{
\item{n}{the observed counts (a 2xc matrix)}

\item{direction}{the direction of column probabilities ("increasing" or "decreasing")}

\item{printresults}{display results (0 = no, 1 = yes)}
}
\value{
A list containing the two-sided p-value and the test statistic for the likelihood ratio and the Pearson chi-squared tests
}
\description{
The Pearson chi-squared and likelihood ratio tests for cumulative ORs in 2xc tables

Described in Chapter 6 "The Ordered 2xc Table"
}
\examples{
# Postoperative nausea (Lydersen et al., 2012a)
n <- rbind(c(14, 10, 3, 2), c(11, 7, 8, 4))
Pearson_LR_tests_cum_OR_2xc(n)
}
