% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FleissLevinPaik_test_paired_cxc.R
\name{FleissLevinPaik_test_paired_cxc}
\alias{FleissLevinPaik_test_paired_cxc}
\title{The Fleiss-Levin-Paik test for three-level ordinal outcomes}
\usage{
FleissLevinPaik_test_paired_cxc(n, printresults = TRUE)
}
\arguments{
\item{n}{the observed table (a cxc matrix)}

\item{printresults}{display results (FALSE = no, TRUE = yes)}
}
\value{
A list containing the probability, the statistic and the degrees of freedom
}
\description{
The Fleiss-Levin-Paik test for three-level ordinal outcomes

Described in Chapter 9 "The Paired cxc Table"
}
\examples{
# Pretherapy susceptability of pathogens *without the N / A category*
# (Peterson et al., 2007)
n <- rbind(c(596, 18, 6), c(0, 2, 0), c(0, 0, 42))
FleissLevinPaik_test_paired_cxc(n)
}
