% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Pearson_LR_tests_cum_OR_2xc.R
\name{Pearson_LR_tests_cum_OR_2xc}
\alias{Pearson_LR_tests_cum_OR_2xc}
\title{The Pearson chi-squared and likelihood ratio tests for cumulative ORs in 2xc tables}
\usage{
Pearson_LR_tests_cum_OR_2xc(n, direction = "decreasing")
}
\arguments{
\item{n}{the observed counts (a 2xc matrix)}

\item{direction}{the direction of column probabilities ("increasing" or "decreasing")}
}
\value{
An object of the \link{contingencytables_result} class,
basically a subclass of \code{\link[base:list]{base::list()}}. Use the \code{\link[utils:str]{utils::str()}} function
to see the specific elements returned.
}
\description{
The Pearson chi-squared and likelihood ratio tests for cumulative ORs in 2xc tables

Described in Chapter 6 "The Ordered 2xc Table"
}
\examples{
# Postoperative nausea (Lydersen et al., 2012a)
Pearson_LR_tests_cum_OR_2xc(lydersen_2012a)
}
