% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delta_conv.R
\name{delta_conv}
\alias{delta_conv}
\title{Delta-convergence statistic}
\usage{
delta_conv(
  tavDes,
  timeName = "time",
  indiType = "highBest",
  time_0 = NA,
  time_t = NA,
  extended = FALSE
)
}
\arguments{
\item{tavDes}{the dataframe time by countries.}

\item{timeName}{the name of the variable that contains time information;
if it is set to NA then no time information is exploited.}

\item{indiType}{the indicator type; the default is "highBest", otherwise
it is equal to "lowBest".}

\item{time_0}{starting time to consider; if NA all times considered.}

\item{time_t}{last time to consider; if NA all times considered.}

\item{extended}{if FALSE only  measures of convergence are produced, otherwise
the declaration of convergence is also provided.}
}
\value{
a tibble with the value of delta-conv (called delta) along time,
         which is called 'time'.
}
\description{
Given a dataframe of quantitative indicators along time,
the delta convergence is a statistic describing departures from best performer.
A time variable may be present or not, but if it is not present
then rows must be already sorted. Missing values are not allowed.
If the time variable is omitted, subsequent rows are separated
by one time unit.
}
\examples{

# Example 1
# Delta convergence with time present
# Dataframe in the format time by countries:
myTB  <- tibble::tribble(
~time, ~UK, ~DE, ~IT,
1988,   1201, 868, 578,
1989,   1150, 978, 682,
1990,   998,  1250, 332
)
resDelta <- delta_conv(myTB)

# Example 2
# Delta convergence with scrambled time order (time present):
myTB2  <- tibble::tribble(
~time, ~UK, ~DE, ~IT,
1990,   998,  1250, 332,
1988,   1201, 868, 578,
1989,   1150, 978, 682
)
resDelta1<-delta_conv(myTB2)

# Example 3
# Delta convergence, scrambled time and different name for the time variable:
myTB2  <- tibble::tribble(
~years, ~UK, ~DE, ~IT,
90,   998,  1250, 332,
88,   1201, 868, 578,
89,   1150, 978, 682
)
resDelta2 <- delta_conv(myTB2,timeName="years")

# Example 4
# Delta convergence for the emp_20_64_MS Eurofound dataset:
data("emp_20_64_MS")
# check name of the time variable:
names(emp_20_64_MS)

# Calculate delta convergence:
resDelta3<-delta_conv(emp_20_64_MS)

# Obtain measures of delta-convergence and the declaration of convergence:
resDelta4<-delta_conv(emp_20_64_MS, extended = TRUE)

}
\references{
{\url{https://unimi2013-my.sharepoint.com/:u:/g/personal/federico_stefanini_unimi_it/EW0cVSIgbtZAvLPNbqcxdX8Bfn5VGSRHfAH88hQwc_RIEQ?e=MgtSZu}}
}
