% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_parlin.R
\name{ts_parlin}
\alias{ts_parlin}
\title{Time-indicator serie to straight lines parameters}
\usage{
ts_parlin(dataMat)
}
\arguments{
\item{dataMat}{two columns (times, indicator) dataset}
}
\value{
dataset(tibble) where each row is  (times, intercept, slope)
}
\description{
Given a dataset with first column times and second column the indicator values
parameters of time-spliced straight lines are calculated. No checking is
performed in input.
Time values must differ by a positive  constant.
}
\examples{

require(tibble)
testTB <- dplyr::tribble(
    ~time, ~countryA ,  ~countryB,  ~countryC,
    2000,     0.8,   2.7,    3.9,
    2001,     1.2,   3.2,    4.2,
    2002,     0.9,   2.9,    4.1,
    2003,     1.3,   2.9,    4.0,
    2004,     1.2,   3.1,    4.1,
    2005,     1.2,   3.0,    4.0
    )

curcountry <- 2
resPAR <- ts_parlin(testTB[,c(1,curcountry)])

curcountry <- 4
resPAR1 <- ts_parlin(testTB[,c(1,curcountry)])

}
\references{
{\url{https://unimi2013-my.sharepoint.com/:u:/g/personal/federico_stefanini_unimi_it/EW0cVSIgbtZAvLPNbqcxdX8Bfn5VGSRHfAH88hQwc_RIEQ?e=MgtSZu}}
}
