% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unexported.R
\name{.setCacheLocation}
\alias{.setCacheLocation}
\title{Unexported functions
Set the location for the biomaRt cache}
\usage{
.setCacheLocation(cache.dir = rappdirs::user_cache_dir(), app = "biomaRt")
}
\arguments{
\item{cache.dir}{(\code{character}). Optional user-defined path used as cache parent directory. Defaults to \code{rappdirs::user_cache_dir()}. If a custom path is given that has to exist.}

\item{app}{(\code{character}). Optional application-specific cache sub-directory, i.e., the actually used cache location. Defaults to "biomaRt".}
}
\value{
The value of the BIOMART_CACHE environment variable, i.e., the cache location.
}
\description{
\command{.setBiomaRtCacheLocation()} attempts to set the cache location
used by the functions in the 'biomaRt' package and defined in the BIOMART_CACHE
environment variable.
If that variable is set and the defined location exists and is writable nothing is done.
If the system default cache location exists and is writable a sub-folder \code{app} is used (and created if necessary).
If the above don't work a new path is constructed from \code{cache.dir} and the \code{app} folder and an attempt is made to create that.
If all of the above fail the function attempts to create \code{file.path(tempdir(), app)}. If tat fails, too,
an exception is thrown.
}
\examples{
\dontrun{.setCacheLocation()}
}
\seealso{
\code{\link[rappdirs]{user_cache_dir}}, \code{\link[BiocFileCache]{BiocFileCache}}
}
\keyword{internal}
