% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convratsig.R
\name{convratsig}
\alias{convratsig}
\title{Tests the signifiance of convergent evolution by the ratio of the current to maximum past phenotypic distance}
\usage{
convratsig(phyl, phendata, convtips, nsim)
}
\arguments{
\item{phyl}{The phylogeny of interest in phylo format}

\item{phendata}{Phenotypic data for all tips}

\item{convtips}{A list consisting of the names of all convergent taxa}

\item{nsim}{The number of simulations to conduct}
}
\value{
The convergence metric of interest (C1, C2, etc...), a cutoff value (the value that the observed measure would have to exceed in order to be considered significant), a P-value for the statistic, and all simulated values.
}
\description{
convratsig tests the significance of convergence (as quantified by convrat) using evolutionary simulations.
}
\details{
The function simulates evolution via Brownian motion using the input tree and parameters derived from the observed data.  It calculates a convergence metric for each simulation and calculates statistics from the number of times the simulated value exceeds the observed value.
}
\examples{

phyl<-rtree(10)
phendata<-fastBM(phyl,nsim=2)
convtips<-c("t1","t2","t3")
answer<-convratsig(phyl,phendata,convtips,10)
}
\references{
Paradis, E., J. Claude, and K. Strimmer (2004) APE: Analyses of phylogenetics
and evolution in R langauge. Bioinformatics, 20, 289-290.

Revell, L. J. (2012) phytools: An R package for phylogenetic comparative
biology (and other things). Methods Ecol. Evol. 3 217-223.
}
