% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/convoSPAT_fitpred.R
\name{NSconvo_fit}
\alias{NSconvo_fit}
\title{Fit the nonstationary spatial model}
\usage{
NSconvo_fit(geodata, coords = geodata$coords, data = geodata$data,
  cov.model = "exponential", mean.model = data ~ 1, mc.locations = NULL,
  N.mc = NULL, lambda.w = NULL, mc.kernels = NULL, fit.radius = NULL,
  ns.nugget = FALSE, ns.variance = FALSE, local.pars.LB = NULL,
  local.pars.UB = NULL, global.pars.LB = NULL, global.pars.UB = NULL,
  local.ini.pars = NULL, global.ini.pars = NULL)
}
\arguments{
\item{geodata}{A list containing elements \code{coords} and \code{data} as
described next. Typically an object of the class "\code{geodata}", although
a geodata object only allows \code{data} to be a vector (no replicates).
If not provided, the arguments \code{coords} and \code{data} must be
provided instead.}

\item{coords}{An N x 2 matrix where each row has the two-dimensional
coordinates of the N data locations. By default, it takes the \code{coords}
component of the argument \code{geodata}, if provided.}

\item{data}{A vector or matrix with N rows, containing the data values.
Inputting a vector corresponds to a single replicate of data, while
inputting a matrix corresponds to replicates. In the case of replicates,
the model assumes the replicates are independent and identically
distributed.}

\item{cov.model}{A string specifying the model for the correlation
function; following \code{geoR}, defaults to \code{"exponential"}.
Options available in this package are: "\code{exponential}",
\code{"cauchy"}, \code{"matern"}, \code{"circular"}, \code{"cubic"},
\code{"gaussian"}, \code{"spherical"}, and \code{"wave"}. For further
details, see documentation for \code{\link[geoR]{cov.spatial}}.}

\item{mean.model}{An object of class \code{\link[stats]{formula}},
specifying the mean model to be used. Defaults to an intercept only.}

\item{mc.locations}{Optional; matrix of mixture component locations.}

\item{N.mc}{Optional; if \code{mc.locations} is not specified, the
function will create a rectangular grid of size \code{N.mc} over the
spatial domain.}

\item{lambda.w}{Scalar; tuning parameter for the weight function.
Defaults to be the square of one-half of the minimum distance between
mixture component locations.}

\item{mc.kernels}{Optional specification of mixture component kernel
matrices (based on expert opinion, etc.).}

\item{fit.radius}{Scalar; specifies the fit radius or neighborhood size
for the local likelihood estimation.}

\item{ns.nugget}{Logical; indicates if the nugget variance (tausq) should
be spatially-varying (\code{TRUE}) or constant (\code{FALSE}).}

\item{ns.variance}{Logical; indicates if the process variance (sigmasq)
should be spatially-varying (\code{TRUE}) or constant (\code{FALSE}).}

\item{local.pars.LB,local.pars.UB}{Optional vectors of lower and upper
bounds, respectively, used by the \code{"L-BFGS-B"} method option in the
\code{\link[stats]{optim}} function for the local parameter estimation.
Each vector must be of length five,
containing values for lam1, lam2, tausq, sigmasq, and nu. Default for
\code{local.pars.LB} is \code{rep(1e-05,5)}; default for
\code{local.pars.UB} is \code{c(max.distance/2, max.distance/2, 4*resid.var, 4*resid.var, 100)},
where \code{max.distance} is the maximum interpoint distance of the
observed data and \code{resid.var} is the residual variance from using
\code{\link[stats]{lm}} with \code{mean.model}.}

\item{global.pars.LB,global.pars.UB}{Optional vectors of lower and upper
bounds, respectively, used by the \code{"L-BFGS-B"} method option in the
\code{\link[stats]{optim}} function for the global parameter estimation.
Each vector must be of length three,
containing values for tausq, sigmasq, and nu. Default for
\code{global.pars.LB} is \code{rep(1e-05,3)}; default for
\code{global.pars.UB} is \code{c(4*resid.var, 4*resid.var, 100)},
where \code{resid.var} is the residual variance from using
\code{\link[stats]{lm}} with \code{mean.model}.}

\item{local.ini.pars}{Optional vector of initial values used by the
\code{"L-BFGS-B"} method option in the \code{\link[stats]{optim}}
function for the local parameter estimation. The vector must be of length
five, containing values for lam1, lam2, tausq, sigmasq, and nu. Defaults
to \code{c(max.distance/10, max.distance/10, 0.1*resid.var, 0.9*resid.var, 1)},
where \code{max.distance} is the maximum interpoint distance of the
observed data and \code{resid.var} is the residual variance from using
\code{\link[stats]{lm}} with \code{mean.model}.}

\item{global.ini.pars}{Optional vector of initial values used by the
\code{"L-BFGS-B"} method option in the \code{\link[stats]{optim}}
function for the global parameter estimation. The vector must be of length
three, containing values for tausq, sigmasq, and nu. Defaults to
\code{c(0.1*resid.var, 0.9*resid.var, 1)}, where \code{resid.var} is the
residual variance from using \code{\link[stats]{lm}} with \code{mean.model}.}
}
\value{
A list with the following components:
\item{mc.locations}{Mixture component locations used for the simulated
data.}
\item{mc.kernels}{Mixture component kernel matrices used for the simulated
data.}
\item{MLEs.save}{Table of local maximum likelihood estimates for each
mixture component location.}
\item{kernel.ellipses}{\code{N.obs} x 2 x 2 array, containing the kernel
matrices corresponding to each of the simulated values.}
\item{data}{Observed data values.}
\item{beta.GLS}{Vector of generalized least squares estimates of beta,
the mean coefficients.}
\item{beta.cov}{Covariance matrix of the generalized least squares
estimate of beta.}
\item{Mean.coefs}{"Regression table" for the mean coefficient estimates,
listing the estimate, standard error, and t-value.}
\item{tausq.est}{Estimate of tausq (nugget variance), either scalar (when
\code{ns.nugget = "FALSE"}) or a vector of length N (when
\code{ns.nugget = "TRUE"}), which contains the estimated nugget variance
for each observation location.}
\item{sigmasq.est}{Estimate of sigmasq (process variance), either scalar
(when \code{ns.variance = "FALSE"}) or a vector of length N (when
\code{ns.variance = "TRUE"}), which contains the estimated process
variance for each observation location.}
\item{kappa.MLE}{Scalar maximum likelihood estimate for kappa (when
applicable).}
\item{Cov.mat}{Estimated covariance matrix (\code{N.obs} x \code{N.obs})
using all relevant parameter estimates.}
\item{Cov.mat.inv}{Inverse of \code{Cov.mat}, the estimated covariance
matrix (\code{N.obs} x \code{N.obs}).}
\item{cov.model}{String; the correlation model used for estimation.}
\item{ns.nugget}{Logical, indicating if the nugget variance was estimated
as spatially-varing (\code{TRUE}) or constant (\code{FALSE}).}
\item{ns.variance}{Logical, indicating if the process variance was
estimated as spatially-varying (\code{TRUE}) or constant (\code{FALSE}).}
\item{coords}{N x 2 matrix of observation locations.}
\item{global.loglik}{Scalar value of the maximized likelihood from the
global optimization (if available).}
\item{Xmat}{Design matrix, obtained from using \code{\link[stats]{lm}}
with \code{mean.model}.}
\item{lambda.w}{Tuning parameter for the weight function.}
}
\description{
\code{NSconvo_fit} estimates the parameters of the nonstationary
convolution-based spatial model. Required inputs are the observed data and
locations (a geoR object with $coords and $data).
Optional inputs include mixture component locations (if not provided,
the number of mixture component locations are required), the fit radius,
the covariance model (exponential is the default), and whether or not the
nugget and process variance will be spatially-varying.
}
\examples{
# Using white noise data
fit.model <- NSconvo_fit( coords = cbind( runif(100), runif(100)),
data = rnorm(100), fit.radius = 0.4, N.mc = 4 )
}

