% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/convoSPAT_fitpred.R
\name{NSconvo_pred}
\alias{NSconvo_pred}
\title{Obtain predictions at unobserved locations for the nonstationary
spatial model.}
\usage{
NSconvo_pred(NSconvo.fit.obj, pred.coords, pred.covariates = NULL)
}
\arguments{
\item{NSconvo.fit.obj}{Object from calling \code{NSconvo_fit}.}

\item{pred.coords}{Matrix of locations where predictions are required.}

\item{pred.covariates}{Matrix of covariates for the prediction locations,
NOT including an intercept. The number of columns for this matrix must
match the design matrix from \code{mean.model} in \code{\link{NSconvo_fit}}.
Defaults to an intercept only.}
}
\value{
A list with the following components:
\item{pred.means}{Vector of the kriging predictor, for each location in
\code{pred.coords}.}
\item{pred.SDs}{Vector of the kriging standard errors, for each location
in \code{pred.coords}.}
}
\description{
\code{NSconvo_pred} calculates the kriging predictor and corresponding
standard errors at unmonitored sites.
}
\examples{
\dontrun{
pred.NS <- NSconvo_pred( NSconvo.fit.obj = fit.model,
pred.coords = matrix(c(1,1), ncol=2),
pred.covariates = matrix(c(1,1), ncol=2) )
}
}

