% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/griddata.R
\name{griddata}
\alias{griddata}
\title{Grid 1D point set}
\usage{
griddata(x, w = NULL, n = 20, xlim = NULL)
}
\arguments{
\item{x}{N-element vector of points}

\item{w}{optional N-element vector with weights}

\item{n}{scalar specifying the number of equally space grid cells}

\item{xlim}{2-element vector specifying the data range (data cropped if necessary). If not given, xlim is set to the full range of x.}
}
\value{
Returns a list of items
\item{x}{n-element vector of cell-center x-coordinates}
\item{xbreak}{(n+1)-element vector of cell-edge x-coordinates}
\item{dx}{spacing between x-coordinates}
\item{xlim}{range of xbreak, same as input argument xlim, if given}
\item{n}{n-element vector giving the number of points in each grid cell}
\item{m}{n-element vector of weighted point counts (masses); only available if \code{w} is specified.}
\item{d}{normalized number densities corresponding to n, such that sum(d)*dx=1.}
\item{c}{normalized mass densities corresponding to m, such that sum(c)*dx=1; only available if \code{w} is specified.}
}
\description{
Generates a regular 1D grid from a 1D point set, optionally with weights; similar to hist.
}
\examples{
set.seed(1)
x = runif(2000)
g = griddata(x,xlim=c(0,1))
plot(g$x,g$n,xlim=c(0,1),ylim=c(0,max(g$n)),pch=20,type='l')

}
\seealso{
\code{\link{griddata2}}
}
\author{
Danail Obreschkow
}
