% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotCoreSet.R
\name{plotCoreSet}
\alias{plotCoreSet}
\title{Plot Core Set for cooperative production linear games.}
\usage{
plotCoreSet(game, owenPoint)
}
\arguments{
\item{game}{vector that represents a cooperative linear production game.}

\item{owenPoint}{matrix with allocations of Owen Set.}
}
\value{
\code{plotCoreSet} returns a \code{ggplot} object with the imputation set
of the game, the core and the most common solutions.
}
\description{
Given a linear production game \code{A \%*\% x <= b(S)}, the 
\code{plotCoreSet} plots the imputation Set, Core Set and the most common
solutions (Nucleoulus, Shapley Value and allocations 
of Owen Set.)
}
\details{
This function plots all allocations of Owen Set. If we have multiple 
allocations, we should pass the ends of the segment that represents all 
the possible allocations.
}
\examples{
# Game
game <- c(68,102,0,170,710,762,992)
# Owen allocation of the game
owenPoint <- matrix(c(230, 282, 480), nrow = 1)
# Plot Core set
plotCoreSet(game, owenPoint)
  
  
}
\seealso{
\code{\link{coopProductGame}}
}
\author{
D. Prieto
}
