% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotlm.R
\name{plotlm}
\alias{plotlm}
\title{Plot method for linear production programming problems}
\usage{
plotlm(prod, A, b, c, title = NULL)
}
\arguments{
\item{prod}{a linear production programming problem of class \code{lpExtPtr}.}

\item{A}{production matrix.}

\item{b}{vector of resources.}

\item{c}{vector of benefits.}

\item{title}{title of the plot. By default is \code{NULL}, so it returns a plot
without title.}
}
\value{
Returns and plot a \code{ggplot} object with graphical solution of 
the problem.
}
\description{
This function plots the graphical solution of simple linear production 
programming problems with two decision 
variables. The decision variables must be real, nonnegative and cannot 
have a finite upper bound. Only inequality constraints are supported.
}
\examples{
# Vector of benefits
c <- c(68,52)
# Matrix of coefficients
A <- matrix(c(4,5,6,2), ncol = 2, byrow = TRUE)
# Vector of resources
b <- c(4,33)
# Make the associated linear program 
prod <- makeLP(c, A, b)
plotlm(prod, A, b, c)

}
\seealso{
\code{\link{makeLP}}.
}
\author{
D. Prieto
}
