% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cops.R
\name{copstress}
\alias{copstress}
\title{Calculates copstress for given MDS object}
\usage{
copstress(
  obj,
  stressweight = 1,
  cordweight = 5,
  q = 1,
  minpts = 2,
  epsilon = 10,
  rang = NULL,
  verbose = 0,
  normed = TRUE,
  scale = c("std", "sd", "proc", "none"),
  init,
  ...
)
}
\arguments{
\item{obj}{MDS object (supported are sammon, cmdscale, smacof, rstress, powermds)}

\item{stressweight}{weight to be used for the fit measure; defaults to 1}

\item{cordweight}{weight to be used for the cordillera; defaults to 0.5}

\item{q}{the norm of the cordillera; defaults to 1}

\item{minpts}{the minimum points to make up a cluster in OPTICS; defaults to 2}

\item{epsilon}{the epsilon parameter of OPTICS, the neighbourhood that is checked; defaults to 10}

\item{rang}{range of the distances (min distance minus max distance). If NULL (default) the cordillera will be normed to each configuration's maximum distance, so an absolute value of goodness-of-clusteredness.}

\item{verbose}{numeric value hat prints information on the fitting process; >2 is very verbose (copstress level), >3 is extremely (up to MDS optimization level)}

\item{normed}{should the cordillera be normed; defaults to TRUE}

\item{scale}{should the configuration be scale adjusted.}

\item{init}{a reference configuration when doing procrustes adjustment}

\item{...}{additional arguments to be passed to the cordillera function}
}
\value{
A list with the components
\itemize{
       \item copstress: the weighted loss value
       \item OC: the Optics cordillera value
       \item parameters: the parameters used for fitting (kappa, lambda)
       \item cordillera: the cordillera object
}
}
\description{
Calculates copstress for given MDS object
}
\keyword{multivariate}
