/*
 * Decompiled with CFR 0.152.
 */
package org.corehunter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.corehunter.CoreHunterArguments;
import org.corehunter.CoreHunterExecutionMode;
import org.corehunter.CoreHunterListener;
import org.corehunter.CoreHunterObjective;
import org.corehunter.CoreHunterObjectiveType;
import org.corehunter.Range;
import org.corehunter.data.CoreHunterData;
import org.corehunter.exceptions.CoreHunterException;
import org.corehunter.objectives.AverageAccessionToNearestEntry;
import org.corehunter.objectives.AverageEntryToEntry;
import org.corehunter.objectives.AverageEntryToNearestEntry;
import org.corehunter.objectives.Coverage;
import org.corehunter.objectives.HeterozygousLoci;
import org.corehunter.objectives.Shannon;
import org.corehunter.objectives.distance.DistanceMeasure;
import org.corehunter.objectives.distance.measures.CavalliSforzaEdwardsDistance;
import org.corehunter.objectives.distance.measures.GowerDistance;
import org.corehunter.objectives.distance.measures.ModifiedRogersDistance;
import org.corehunter.objectives.distance.measures.PrecomputedDistance;
import org.jamesframework.core.problems.objectives.Objective;
import org.jamesframework.core.search.Search;
import org.jamesframework.core.search.algo.ParallelTempering;
import org.jamesframework.core.search.algo.RandomDescent;
import org.jamesframework.core.search.neigh.Neighbourhood;
import org.jamesframework.core.search.stopcriteria.MaxRuntime;
import org.jamesframework.core.search.stopcriteria.MaxTimeWithoutImprovement;
import org.jamesframework.core.subset.SubsetProblem;
import org.jamesframework.core.subset.SubsetSolution;
import org.jamesframework.core.subset.neigh.SingleSwapNeighbourhood;
import org.jamesframework.ext.problems.objectives.NormalizedObjective;
import org.jamesframework.ext.problems.objectives.WeightedIndex;

public class CoreHunter {
    private static final int DEFAULT_MAX_TIME_WITHOUT_IMPROVEMENT = 10000;
    private static final int FAST_MAX_TIME_WITHOUT_IMPROVEMENT = 2000;
    private static final int PT_NUM_REPLICAS = 10;
    private static final double PT_MIN_TEMP = 1.0E-8;
    private static final double PT_MAX_TEMP = 1.0E-4;
    private CoreHunterListener listener;
    private long timeLimit = -1L;
    private long maxTimeWithoutImprovement = -1L;
    private CoreHunterExecutionMode mode;

    public CoreHunter() {
        this(CoreHunterExecutionMode.DEFAULT);
    }

    public CoreHunter(CoreHunterExecutionMode mode) {
        this.mode = mode;
        this.maxTimeWithoutImprovement = 10000L;
        if (mode == CoreHunterExecutionMode.FAST) {
            this.maxTimeWithoutImprovement = 2000L;
        }
    }

    public List<Range<Double>> normalize(CoreHunterArguments arguments) {
        if (arguments == null) {
            throw new IllegalArgumentException("Arguments not defined!");
        }
        CoreHunterData data = arguments.getData();
        if (data == null) {
            throw new IllegalArgumentException("Dataset not defined!");
        }
        if (!arguments.isNormalized()) {
            throw new IllegalArgumentException("Normalization is disabled.");
        }
        List<CoreHunterObjective> objectives = arguments.getObjectives();
        if (objectives == null || objectives.isEmpty()) {
            throw new IllegalArgumentException("Objectives not defined!");
        }
        if (objectives.size() < 2) {
            throw new IllegalArgumentException("At least two objectives required for Pareto normalization.");
        }
        int size = arguments.getSubsetSize();
        SingleSwapNeighbourhood neigh = new SingleSwapNeighbourhood();
        List bestSolutions = objectives.parallelStream().map(obj -> {
            Objective<SubsetSolution, CoreHunterData> jamesObj = this.createObjective(data, (CoreHunterObjective)obj);
            SubsetProblem<CoreHunterData> problem = new SubsetProblem<CoreHunterData>(data, jamesObj, size);
            RandomDescent<SubsetSolution> normSearch = new RandomDescent<SubsetSolution>(problem, neigh);
            if (this.timeLimit > 0L) {
                normSearch.addStopCriterion(new MaxRuntime(this.timeLimit, TimeUnit.MILLISECONDS));
            }
            if (this.maxTimeWithoutImprovement > 0L) {
                normSearch.addStopCriterion(new MaxTimeWithoutImprovement(this.maxTimeWithoutImprovement, TimeUnit.MILLISECONDS));
            }
            normSearch.run();
            return (SubsetSolution)normSearch.getBestSolution();
        }).collect(Collectors.toList());
        ArrayList<Range<Double>> ranges = new ArrayList<Range<Double>>();
        for (int o = 0; o < objectives.size(); ++o) {
            double max;
            double min;
            Objective<SubsetSolution, CoreHunterData> obj2 = this.createObjective(data, objectives.get(o));
            List allValues = bestSolutions.stream().map(sol -> obj2.evaluate((SubsetSolution)sol, data).getValue()).collect(Collectors.toList());
            double bestValue = (Double)allValues.get(o);
            if (obj2.isMinimizing()) {
                min = bestValue;
                max = (Double)Collections.max(allValues);
            } else {
                max = bestValue;
                min = (Double)Collections.min(allValues);
            }
            ranges.add(new Range<Double>(min, max));
        }
        return ranges;
    }

    public SubsetSolution execute(CoreHunterArguments arguments) {
        if (arguments == null) {
            throw new IllegalArgumentException("Arguments not defined!");
        }
        if (arguments.getData() == null) {
            throw new IllegalArgumentException("Dataset not defined!");
        }
        Search<SubsetSolution> search = this.createSearch(arguments);
        if (this.timeLimit <= 0L && this.maxTimeWithoutImprovement <= 0L) {
            throw new IllegalStateException("Please specify time limit and/or maximum time without improvement before execution.");
        }
        if (this.timeLimit > 0L) {
            search.addStopCriterion(new MaxRuntime(this.timeLimit, TimeUnit.MILLISECONDS));
        }
        if (this.maxTimeWithoutImprovement > 0L) {
            search.addStopCriterion(new MaxTimeWithoutImprovement(this.maxTimeWithoutImprovement, TimeUnit.MILLISECONDS));
        }
        if (this.listener != null) {
            search.addSearchListener(this.listener);
        }
        search.start();
        search.dispose();
        return search.getBestSolution();
    }

    public double evaluate(SubsetSolution sol, CoreHunterData data, CoreHunterObjective objective) {
        Objective<SubsetSolution, CoreHunterData> obj = this.createObjective(data, objective);
        return obj.evaluate(sol, data).getValue();
    }

    public long getTimeLimit() {
        return this.timeLimit;
    }

    public void setTimeLimit(long ms) {
        this.timeLimit = ms;
    }

    public long getMaxTimeWithoutImprovement() {
        return this.maxTimeWithoutImprovement;
    }

    public void setMaxTimeWithoutImprovement(long ms) {
        this.maxTimeWithoutImprovement = ms;
    }

    public CoreHunterListener getListener() {
        return this.listener;
    }

    public void setListener(CoreHunterListener listener) {
        this.listener = listener;
    }

    protected Search<SubsetSolution> createSearch(CoreHunterArguments arguments) {
        int size = arguments.getSubsetSize();
        Objective<SubsetSolution, CoreHunterData> objective = this.createObjective(arguments);
        SubsetProblem<CoreHunterData> problem = new SubsetProblem<CoreHunterData>(arguments.getData(), objective, size);
        SingleSwapNeighbourhood neigh = new SingleSwapNeighbourhood();
        Search<SubsetSolution> search = this.createSearch(problem, neigh);
        return search;
    }

    private Search<SubsetSolution> createSearch(SubsetProblem<CoreHunterData> problem, Neighbourhood<SubsetSolution> neigh) {
        switch (this.mode) {
            case DEFAULT: {
                return new ParallelTempering<SubsetSolution>(problem, neigh, 10, 1.0E-8, 1.0E-4);
            }
            case FAST: {
                return new RandomDescent<SubsetSolution>(problem, neigh);
            }
        }
        throw new CoreHunterException("Unknown execution mode " + (Object)((Object)this.mode) + ".");
    }

    private Objective<SubsetSolution, CoreHunterData> createObjective(CoreHunterArguments arguments) {
        CoreHunterData data = arguments.getData();
        List<CoreHunterObjective> objectives = arguments.getObjectives();
        if (objectives == null || objectives.isEmpty()) {
            throw new CoreHunterException("No objective(s) given.");
        }
        if (objectives.size() == 1) {
            return this.createObjective(data, objectives.get(0));
        }
        WeightedIndex<SubsetSolution, CoreHunterData> weightedIndex = new WeightedIndex<SubsetSolution, CoreHunterData>();
        List<Objective<SubsetSolution, CoreHunterData>> jamesObjectives = objectives.stream().map(obj -> this.createObjective(data, (CoreHunterObjective)obj)).collect(Collectors.toList());
        if (arguments.isNormalized()) {
            jamesObjectives = this.normalizeObjectives(arguments, jamesObjectives);
        }
        for (int o = 0; o < objectives.size(); ++o) {
            weightedIndex.addObjective(jamesObjectives.get(o), objectives.get(o).getWeight());
        }
        return weightedIndex;
    }

    private Objective<SubsetSolution, CoreHunterData> createObjective(CoreHunterData data, CoreHunterObjective coreHunterObjective) {
        Objective<SubsetSolution, CoreHunterData> objective = null;
        DistanceMeasure distanceMeasure = null;
        if (coreHunterObjective.getMeasure() != null) {
            switch (coreHunterObjective.getMeasure()) {
                case MODIFIED_ROGERS: {
                    if (!data.hasGenotypes()) {
                        throw new CoreHunterException("Genotypes are required for Modified Rogers distance.");
                    }
                    distanceMeasure = new ModifiedRogersDistance();
                    break;
                }
                case CAVALLI_SFORZA_EDWARDS: {
                    if (!data.hasGenotypes()) {
                        throw new CoreHunterException("Genotypes are required for Cavalli-Sforza and Edwards distance.");
                    }
                    distanceMeasure = new CavalliSforzaEdwardsDistance();
                    break;
                }
                case GOWERS: {
                    if (!data.hasPhenotypes()) {
                        throw new CoreHunterException("Phenotypes are required for Gower distance.");
                    }
                    distanceMeasure = new GowerDistance();
                    break;
                }
                case PRECOMPUTED_DISTANCE: {
                    if (!data.hasDistances()) {
                        throw new CoreHunterException("No precomputed distance matrix has been defined.");
                    }
                    distanceMeasure = new PrecomputedDistance();
                    break;
                }
            }
        }
        switch (coreHunterObjective.getObjectiveType()) {
            case AV_ACCESSION_TO_NEAREST_ENTRY: {
                if (distanceMeasure == null) {
                    throw new CoreHunterException(String.format("No distance measure defined. A distance measure is required for %s", new Object[]{CoreHunterObjectiveType.AV_ACCESSION_TO_NEAREST_ENTRY}));
                }
                objective = new AverageAccessionToNearestEntry(distanceMeasure);
                break;
            }
            case AV_ENTRY_TO_ENTRY: {
                if (distanceMeasure == null) {
                    throw new CoreHunterException(String.format("No distance measure defined. A distance measure is required for %s", new Object[]{CoreHunterObjectiveType.AV_ENTRY_TO_ENTRY}));
                }
                objective = new AverageEntryToEntry(distanceMeasure);
                break;
            }
            case AV_ENTRY_TO_NEAREST_ENTRY: {
                if (distanceMeasure == null) {
                    throw new CoreHunterException(String.format("No distance measure defined. A distance measure is required for %s", new Object[]{CoreHunterObjectiveType.AV_ENTRY_TO_NEAREST_ENTRY}));
                }
                objective = new AverageEntryToNearestEntry(distanceMeasure);
                break;
            }
            case COVERAGE: {
                if (!data.hasGenotypes()) {
                    throw new CoreHunterException("Genotypes are required for coverage objective.");
                }
                objective = new Coverage();
                break;
            }
            case HETEROZYGOUS_LOCI: {
                if (!data.hasGenotypes()) {
                    throw new CoreHunterException("Genotypes are required for expected proportion of heterozygous loci objective.");
                }
                objective = new HeterozygousLoci();
                break;
            }
            case SHANNON_DIVERSITY: {
                if (!data.hasGenotypes()) {
                    throw new CoreHunterException("Genotypes are required for Shannon's index.");
                }
                objective = new Shannon();
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unknown objective : %s", coreHunterObjective));
            }
        }
        return objective;
    }

    private List<Objective<SubsetSolution, CoreHunterData>> normalizeObjectives(CoreHunterArguments arguments, List<Objective<SubsetSolution, CoreHunterData>> objectives) {
        List<Range<Double>> ranges;
        List<CoreHunterObjective> chObjectives;
        if (this.listener != null) {
            this.listener.preprocessingStarted("Normalizing objectives.");
        }
        if ((chObjectives = arguments.getObjectives()).stream().map(CoreHunterObjective::getNormalizationRange).anyMatch(Objects::isNull)) {
            ranges = this.normalize(arguments);
            for (int o = 0; o < chObjectives.size(); ++o) {
                Range<Double> range = chObjectives.get(o).getNormalizationRange();
                if (range == null) continue;
                ranges.set(o, range);
            }
        } else {
            ranges = chObjectives.stream().map(CoreHunterObjective::getNormalizationRange).collect(Collectors.toList());
        }
        StringBuilder message = new StringBuilder();
        ArrayList<Objective<SubsetSolution, CoreHunterData>> normalizedObjectives = new ArrayList<Objective<SubsetSolution, CoreHunterData>>();
        for (int o = 0; o < objectives.size(); ++o) {
            Objective<SubsetSolution, CoreHunterData> obj = objectives.get(o);
            Range<Double> range = ranges.get(o);
            double min = range.getLower();
            double max = range.getUpper();
            normalizedObjectives.add(new NormalizedObjective<SubsetSolution, CoreHunterData>(obj, min, max));
            message.append(String.format(Locale.ROOT, "%s: [%.3f, %.3f]%n", obj, min, max));
        }
        message.append("Finished normalization.");
        if (this.listener != null) {
            this.listener.preprocessingStopped(message.toString());
        }
        return normalizedObjectives;
    }
}

