/*
 * Decompiled with CFR 0.152.
 */
package org.corehunter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.corehunter.CoreHunterMeasure;
import org.corehunter.CoreHunterObjective;
import org.corehunter.CoreHunterObjectiveType;
import org.corehunter.data.CoreHunterData;

public class CoreHunterArguments {
    private int subsetSize;
    private CoreHunterData data;
    private List<CoreHunterObjective> objectives;
    private boolean normalize;

    private CoreHunterArguments(CoreHunterData data, int subsetSize) {
        if (data == null) {
            throw new IllegalArgumentException("Data undefined.");
        }
        if (subsetSize < 2) {
            throw new IllegalArgumentException("Requested subset size must at least be 2 or more.");
        }
        if (subsetSize >= data.getSize()) {
            throw new IllegalArgumentException(String.format("Requested subset size must be less than total data size %d.", data.getSize()));
        }
        this.data = data;
        this.subsetSize = subsetSize;
    }

    public CoreHunterArguments(CoreHunterData data, int subsetSize, CoreHunterObjectiveType objective) {
        this(data, subsetSize);
        if (objective == null) {
            throw new IllegalArgumentException("Objective not defined.");
        }
        this.objectives = Collections.singletonList(new CoreHunterObjective(objective));
        this.normalize = false;
    }

    public CoreHunterArguments(CoreHunterData data, int subsetSize, CoreHunterObjectiveType objective, CoreHunterMeasure measure) {
        this(data, subsetSize);
        if (objective == null) {
            throw new IllegalArgumentException("Objective not defined.");
        }
        if (measure == null) {
            throw new IllegalArgumentException("Measure not defined.");
        }
        this.objectives = Collections.singletonList(new CoreHunterObjective(objective, measure));
        this.normalize = false;
    }

    public CoreHunterArguments(CoreHunterData data, int subsetSize, List<CoreHunterObjective> objectives) {
        this(data, subsetSize, objectives, true);
    }

    public CoreHunterArguments(CoreHunterData data, int subsetSize, List<CoreHunterObjective> objectives, boolean normalize) {
        this(data, subsetSize);
        if (objectives == null || objectives.isEmpty()) {
            throw new IllegalArgumentException("Objectives not defined.");
        }
        this.objectives = Collections.unmodifiableList(new ArrayList<CoreHunterObjective>(objectives));
        this.normalize = objectives.size() > 1 && normalize;
    }

    public final CoreHunterData getData() {
        return this.data;
    }

    public final List<CoreHunterObjective> getObjectives() {
        return this.objectives;
    }

    public final int getSubsetSize() {
        return this.subsetSize;
    }

    public final boolean isNormalized() {
        return this.normalize;
    }
}

