% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/execution.R
\name{sampleCore}
\alias{sampleCore}
\title{Sample a core collection from the given data.}
\usage{
sampleCore(data, obj, size = 0.2, mode = c("default", "fast"),
  normalize = TRUE, time = NA, impr.time = NA, indices = FALSE,
  verbose = FALSE)
}
\arguments{
\item{data}{Core Hunter data (\code{chdata}) containing genotypes,
phenotypes and/or a precomputed distance matrix. Typically the
data is obtained with \code{\link{coreHunterData}}. Can also be
an object of class \code{chdist}, \code{chgeno} or \code{chpheno}
if only one type of data is provided.}

\item{obj}{Objective or list of objectives (\code{chobj}).
If no objectives are specified Core Hunter maximizes a weighted
index including the default entry-to-nearest-entry distance
(\code{EN}) for each available data type, with equal weight.
For genotyes, the Modified Roger's distance (\code{MR}) is
used. For phenotypes, Gower's distance (\code{GD}) is applied.}

\item{size}{Desired core subset size (numeric). If larger than one the value
is used as the absolute core size after rounding. Else it is used as the
sampling rate and multiplied with the dataset size to determine the size of
the core. The default sampling rate is 0.2.}

\item{mode}{Execution mode (\code{default} or \code{fast}). In default mode,
Core Hunter uses an advanced parallel tempering search algorithm and terminates
when no improvement is found for ten seconds. In fast mode, a simple stochastic
hill-climbing algorithm is applied and Core Hunter terminates as soon as no
improvement is made for two seconds. Stop conditions can be overriden with
arguments \code{time} and \code{impr.time}.}

\item{normalize}{If \code{TRUE} (default) the applied objectives in a multi-objective
configuration (two or more objectives) are automatically normalized prior to execution.
Normalization requires an independent preliminary search per objective (simple stochastic
hill-climber, executed in parallel). If a \code{time} limit or maximum time without
finding an improvement (\code{impr.time}) have been set, the same limits are applied
to each normalization search as well as the main multi-objective search. In case of a
limited number of objectives the total execution time should usually not exceed twice
the imposed search time limit, if any. Normalization ranges can also be precomputed
(see \code{\link{getNormalizationRanges}}) or manually specified in the objectives
to save computation time when sampling core collections. This is especially useful
when multiple cores are sampled for the same objectives, with possibly varying weights.}

\item{time}{Absolute runtime limit in seconds. Not used by default. If used
it should be a strictly positive value and is rounded to the nearest integer.}

\item{impr.time}{Maximum time without improvement in seconds. When set to
\code{NA} a default value is set depending on the execution \code{mode}.
If set to another value it should be strictly positive and is rounded
to the nearest integer.}

\item{indices}{If \code{TRUE} the result contains the indices instead of unique
identifiers (default) of the selected individuals.}

\item{verbose}{If \code{TRUE} search progress messages are printed to the console.
Defaults to \code{FALSE}.}
}
\value{
Core subset (\code{chcore}). It has an element \code{sel}
 which is a character or numeric vector containing the ids or indices,
 respectively, of the selected individuals (see argument \code{indices}).
 In addition the result has one or more elements that indicate the value
 of each objective function that was included in the optimization.
}
\description{
Sample a core collection from the given data.
}
\examples{
\donttest{
data <- exampleData()

# default size, maximize entry-to-nearest-entry Modified Rogers distance
obj <- objective("EN", "MR")
core <- sampleCore(data, obj)

# fast mode
core <- sampleCore(data, obj, mode = "f")
# absolute size
core <- sampleCore(data, obj, size = 25)
# relative size
core <- sampleCore(data, obj, size = 0.1)

# other objective: minimize accession-to-nearest-entry precomputed distance
core <- sampleCore(data, obj = objective(type = "AN", measure = "PD"))
# multiple objectives (equal weight)
core <- sampleCore(data, obj = list(
 objective("EN", "PD"),
 objective("AN", "GD")
))
# multiple objectives (custom weight)
core <- sampleCore(data, obj = list(
 objective("EN", "PD", weight = 0.3),
 objective("AN", "GD", weight = 0.7)
))

# custom stop conditions
core <- sampleCore(data, obj, time = 5, impr.time = 2)

# print progress messages
core <- sampleCore(data, obj, verbose = TRUE)
}

}
\seealso{
\code{\link{coreHunterData}}, \code{\link{objective}}, \code{\link{getNormalizationRanges}}
}

