% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis.R
\name{evaluateCore}
\alias{evaluateCore}
\title{Evaluate a core collection using the specified objective.}
\usage{
evaluateCore(core, data, objective)
}
\arguments{
\item{core}{A core collection of class \code{chcore}, or a
numeric or character vector indicating the indices or ids,
respectively, of the individuals in the evaluated core.}

\item{data}{Core Hunter data (\code{chdata}) containing genotypes,
phenotypes and/or a precomputed distance matrix. Can also be an
object of class \code{chdist}, \code{chgeno} or \code{chpheno}
if only one type of data is provided.}

\item{objective}{Objective function (\code{chobj}) used to evaluate the core.}
}
\value{
Value of the core when evaluated with the chosen objective (numeric).
}
\description{
Evaluate a core collection using the specified objective.
}
\examples{
\donttest{
data <- exampleData()
core <- sampleCore(data, objective("EN", "PD"))
evaluateCore(core, data, objective("EN", "PD"))
evaluateCore(core, data, objective("AN", "MR"))
evaluateCore(core, data, objective("EE", "GD"))
evaluateCore(core, data, objective("CV"))
evaluateCore(core, data, objective("HE"))
}

}
\seealso{
\code{\link{coreHunterData}}, \code{\link{objective}}
}
