% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/untokenize.r
\name{export_span_annotations}
\alias{export_span_annotations}
\title{Export span annotations}
\usage{
export_span_annotations(tc, variables)
}
\arguments{
\item{tc}{A tCorpus, created with \code{\link{create_tcorpus}}, where remember_spaces must have been set to TRUE}

\item{variables}{A character vector with variables (columns in tc$tokens) to export}
}
\value{
A data.table where each row is a span annotation, with columns: doc_id, variable, value, field, offset, length, text
}
\description{
Export columns from a tCorpus as span annotations (annotations over a span of text).
The annotations are returned as a data.table where each row is an annotation, with columns:
doc_id, variable, value, field, offset, length and text. The key purpose is that these span annotations
are linked to exact character positions in the text. This also means that this function can 
only be used if position information is available (i.e. if remember_spaces=T was used when creating the tCorpus)
}
\details{
Note that if there are spans with gaps in them (e.g. based on proximity queries), they are split into different annotations.
Thus some information can be lost.
}
\examples{
tc = create_tcorpus(sotu_texts, c('president','text'), doc_column='id', remember_spaces=TRUE)
tc$code_features(c('war# war peace', 'us being# <(i we) (am are)>'))
export_span_annotations(tc, 'code')
}
