% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corrected_cov_functions.R
\name{corrcov_bhat}
\alias{corrcov_bhat}
\title{Corrected coverage estimate using estimated effect sizes and their standard errors}
\usage{
corrcov_bhat(bhat, V, N0, N1, Sigma, thr, W = 0.2, nrep = 1000,
  pp0min = 0.001)
}
\arguments{
\item{bhat}{Estimated effect sizes from single-SNP logistic regressions}

\item{V}{Variance of estimated effect sizes}

\item{N0}{Number of controls}

\item{N1}{Number of cases}

\item{Sigma}{SNP correlation matrix}

\item{thr}{Minimum threshold for fine-mapping experiment}

\item{W}{Prior for the standard deviation of the effect size parameter, beta (default 0.2)}

\item{nrep}{The number of simulated posterior probability systems to consider for the corrected coverage estimate (default 1000)}

\item{pp0min}{Only average over SNPs with pp0 > pp0min}
}
\value{
Corrected coverage estimate
}
\description{
Corrected coverage estimate using estimated effect sizes and their standard errors
}
\details{
This function only requires the marginal summary statistics from GWAS
}
\examples{

set.seed(1)
nsnps <- 100
N0 <- 1000 # number of controls
N1 <- 1000 # number of cases

## generate example LD matrix
library(mvtnorm)
nsamples = 1000

simx <- function(nsnps, nsamples, S, maf=0.1) {
    mu <- rep(0,nsnps)
    rawvars <- rmvnorm(n=nsamples, mean=mu, sigma=S)
    pvars <- pnorm(rawvars)
    x <- qbinom(1-pvars, 1, maf)
}

S <- (1 - (abs(outer(1:nsnps,1:nsnps,`-`))/nsnps))^4
X <- simx(nsnps,nsamples,S)
LD <- cor2(X)
maf <- colMeans(X)

varbeta <- Var.data.cc(f = maf, N = N0 + N1, s = N1/(N0+N1))

bhats = rnorm(nsnps, 0, 0.2) # log OR

corrcov_bhat(bhat = bhats, V = varbeta, N0, N1, Sigma = LD, thr = 0.95)

}
\author{
Anna Hutchinson
}
