% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsea.R
\name{gsea2}
\alias{gsea2}
\title{2-way GSEA
GSEA Gene set enrichment analysis of two complementary gene sets using gsea}
\usage{
gsea2(
  reflist,
  set1,
  set2,
  method = c("permutation", "pareto"),
  np = 1000,
  w = 1,
  gsea_null = NULL
)
}
\arguments{
\item{reflist}{named vector of reference scores}

\item{set1}{element set 1}

\item{set2}{element set 1}

\item{method}{one of 'permutation' or 'pareto'}

\item{np}{Number of permutations (Default: 1000)}

\item{w}{exponent used to raise the supplied scores. Default is 1 (original
scores unchanged)}

\item{gsea_null}{a GSEA null distribution (Optional)}
}
\value{
A list of 2 GSEA objects. Each of which is a list of components:
\describe{
\item{ES}{The enrichment score}
\item{NES}{The normalized enrichment socre}
\item{ledge}{The items in the leading edge}
\item{p.value}{The permutation-based p-value}
}
}
\description{
2-way GSEA
GSEA Gene set enrichment analysis of two complementary gene sets using gsea
}
\examples{
reflist<-setNames(-sort(rnorm(1000)),paste0('gene',1:1000))
set1<-paste0('gene',sample(1:200,50))
set2<-paste0('gene',sample(801:1000,50))
obj<-gsea2(reflist,set1,set2,method='pareto',np=1000)
obj$p.value
}
