% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal_functions.R
\name{sample_params_mean}
\alias{sample_params_mean}
\title{Sample the parameters for a simple mean-only model}
\usage{
sample_params_mean(y, params)
}
\arguments{
\item{y}{\code{n x 1} vector of data}

\item{params}{the named list of parameters containing
\enumerate{
\item \code{mu}: vector of conditional means (fitted values)
\item \code{sigma}: the conditional standard deviation
\item \code{coefficients}: a named list of parameters that determine \code{mu}
}}
}
\value{
The updated named list \code{params} with draws from the full conditional distributions
of \code{sigma} and \code{coefficients} (and updated \code{mu}).
}
\description{
Sample the parameters for the model y ~ N(mu0, sigma^2)
with a flat prior on mu0 and sigma ~ Unif(0, A).
}
\note{
The only parameter in \code{coefficients} is \code{mu0}.
Although redundant here, this parametrization is useful in other functions.
}
\keyword{internal}
