% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_functions.R
\name{simulate_nb_friedman}
\alias{simulate_nb_friedman}
\title{Simulate count data from Friedman's nonlinear regression}
\usage{
simulate_nb_friedman(
  n = 100,
  p = 10,
  r_nb = 1,
  b_int = log(1.5),
  b_sig = log(5),
  sigma_true = sqrt(2 * log(1)),
  seed = NULL
)
}
\arguments{
\item{n}{number of observations}

\item{p}{number of predictors}

\item{r_nb}{the dispersion parameter of the Negative Binomial dispersion;
smaller values imply greater overdispersion, while larger values approximate the Poisson distribution.}

\item{b_int}{intercept; default is log(1.5).}

\item{b_sig}{regression coefficients for true signals; default is log(5.0).}

\item{sigma_true}{standard deviation of the Gaussian innovation; default is zero.}

\item{seed}{optional integer to set the seed for reproducible simulation; default is NULL
which results in a different dataset after each run}
}
\value{
A named list with the simulated count response \code{y}, the simulated design matrix \code{X},
and the true expected counts \code{Ey}.
}
\description{
Simulate data from a negative-binomial distribution with nonlinear mean function.
}
\details{
The log-expected counts are modeled using the Friedman (1991) nonlinear function
with interactions, possibly
with additional Gaussian noise (on the log-scale). We assume that half of the predictors
are associated with the response, i.e., true signals. For sufficiently large dispersion
parameter \code{r_nb}, the distribution will approximate a Poisson distribution.
Here, the predictor variables are simulated from independent uniform distributions.
}
\note{
Specifying \code{sigma_true = sqrt(2*log(1 + a))} implies that the expected counts are
inflated by \code{100*a}\% (relative to \code{exp(X*beta)}), in addition to providing additional
overdispersion.
}
\examples{
# Simulate and plot the count data:
sim_dat = simulate_nb_friedman(n = 100, p = 10);
plot(sim_dat$y)
}
