% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/couples.R
\docType{class}
\name{couples-class}
\alias{couples-class}
\alias{couples}
\title{Class "couples"}
\usage{
couples(typetest = 0, typecode = numeric())
}
\arguments{
\item{typetest}{integer; set typetest=0 for symmetry test (default choice),
\code{typetest=1} for separability test, \code{typetest=2} for type of non
separability test,
\code{typetest=3} for the test on the product-sum class of models,
\code{typetest=4} for the test on the integrated product class of models,
\code{typetest=5} for the test on the Gneiting class of models}

\item{typecode}{numeric or character; specifies the codification of the
spatial points in the \code{data frame} or in the STFDF/STSDF, typically
output from \code{\link{dataprep}}}
}
\description{
A class for spatial points and the corresponding temporal lags to be
analyzed in order to test some covariance properties and some well known
classes of space-time covariance functions models
}
\details{
The function requires the user to set some external arguments:
\enumerate{
\item the number of spatial points to be analyzed
\item the sequence of ID codes which denote the spatial points to be analyzed
\item the number of spatial couples to be compared
\item the couples of different spatial points
\item the couples of positive and negative temporal lags
}
If some temporal lags, corresponding to some couples of spatial
points, are not required for the specific test, might be set equal to zero.
}
\section{Slots}{

\describe{
\item{\code{couples.st}}{matrix; in which the first two columns contain the
couples of spatial points (denoted with order numbers) to be analyzed
and the other columns the temporal lags associated with each spatial couples}

\item{\code{sel.staz}}{numeric or character; contains the ID codes of the
selected spatial points}

\item{\code{sp.couples}}{data.frame; contains the couples of order numbers
associated with the spatial points to be analyzed and the couples of the
ID codes}

\item{\code{tl.couples}}{numeric; contains the temporal lags associated to the
couples of the selected spatial points}
}}

\note{
It is important to point out that for:
\itemize{
\item symmetry test (\code{typetest=0}), both positive and negative
temporal lags have to be considered;

\item separability and type of non separability tests (\code{typetest=1} and
\code{typetest=2}, respectively), both positive and negative
temporal lags have to be considered. Hovewer, if the symmetry hyphotesis
has not been rejected, only positive temporal lags should be set.
Moreover for \code{typetest=2} the temporal lags should be chosen according
to the results of the sample non separability ratios, plotted through
a boxplot classified for temporal lags (see \linkS4class{sepindex} for more
details);

\item model tests (\code{typetest} from 3 to 5), the number of analyzed spatial
points must be used to create at least 3 spatial couples or multiple of 3,
such that each triplet satisfies the condition h1-h2=h2-h3 (only for typetest=4
and 5). The number of positive temporal lags must be at least 3, or multiple
of 3, too. The condition u1-u2=u2-u3 (only for typetest=4 and 5) must be satisfied
for each triplet. Note that for each spatial triplet and each temporal triplet, 6
contrasts can be defined. However, for typetest=4 (test on the integrated model)
2 contrasts are not necessary (user has to set arbitrarily one temporal lag equal
to zero in order to delete redundant contrasts).



}


Moreover, errors occur if
\itemize{
\item some spatial points, given in the sequence at the beginning of the
function, have not been used to generate the couples of spatial points

\item there is at least one spatial couple with no specification of
temporal lags

\item no temporal lags have been specified

\item the number of spatial points fixed in \code{stpairs} (object of class
\code{couples}) is less than 2
}
}
\examples{
## The function requires to set some external arguments.
# In the example regarding the symmetry test (typetest = 0),
# 12 spatial points, with ID codes: DERP016, ..., DESN049, have been selected,
# then 6 spatial couples ([DERP016, DENW065], .., [DEBY047, DESN049])
# have been formed for comparison. Moreover, 4 positive and negative temporal
# lags have been considered (i.e. +1, -1, +2, -2). Finally, no temporal
# lag has been set equal to zero (Answer "N" to the question "Would you like
# to set some temporal lags equal to 0?"). Hence, for the symmetry test 24 (6*4)
# spatio-temporal comparisons have been fixed.
#
# To run the example, paste and copy the following lines
# (without the symbol '#') in the console
#
#coupl_sim <- couples(typetest = 0, typecode = character())
#12
#DERP016
#DENW065
#DENW063
#DENI019
#DENW068
#DEHE046
#DEHE051
#DETH026
#DEUB029
#DETH061
#DEBY047
#DESN049
#6
#DERP016
#DENW065
#DENW063
#DENI019
#DENW068
#DEHE046
#DEHE051
#DETH026
#DEUB029
#DETH061
#DEBY047
#DESN049
#4
#1
#-1
#2
#-2
#N
}
