% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{covid19nytimes_states_demo}
\alias{covid19nytimes_states_demo}
\title{Demo of US State Data from the NY Times}
\format{
A tibble object
}
\source{
New York Times, "We’re Sharing Coronavirus Case Data for Every U.S.
County"
\href{https://www.nytimes.com/article/coronavirus-county-data-us.html}{article}
and {https://github.com/nytimes/covid-19-data}{data repository}
}
\usage{
covid19nytimes_states_demo
}
\description{
demo of the daily summary of the Coronavirus (Covid-19) total
cases and deaths by state.
}
\details{
The dataset contains the daily summary of Coronavirus cases (total
confirmed and total deaths), by state from the NY Times.

To get the latest data, use \code{\link{refresh_covid19nytimes_states}}
}
\examples{

data(covid19nytimes_states_demo)

require(dplyr)

# Get top confirmed cases by state
covid19nytimes_states_demo \%>\%
  filter(data_type == "cases_total") \%>\%
  filter(value == max(value))
}
\keyword{coronavirus}
\keyword{covid19}
\keyword{covid19nytimes_states}
\keyword{datasets}
