% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_regional_data.R
\name{get_regional_data}
\alias{get_regional_data}
\title{Get regional-level data}
\usage{
get_regional_data(
  country,
  level = "1",
  totals = FALSE,
  localise = TRUE,
  steps = FALSE,
  class = FALSE,
  verbose = TRUE,
  regions,
  ...
)
}
\arguments{
\item{country}{A character string specifying the country to get data from.
Not case dependent. Name should be the English name. For a list of
options use \code{get_available_datasets()}.}

\item{level}{A character string indicating the target administrative level
of the data with the default being "1". Currently supported options are
level 1 ("1) and level 2 ("2"). Use \code{get_available_datasets()} for supported
options by dataset.}

\item{totals}{Logical, defaults to FALSE. If TRUE, returns totalled
data per region up to today's date. If FALSE, returns the full dataset
stratified by date and region.}

\item{localise}{Logical, defaults to TRUE. Should region names be localised.}

\item{steps}{Logical, defaults to FALSE. Should all processing and cleaning
steps be kept and output in a list.}

\item{class}{Logical, defaults to FALSE. If TRUE returns the
\code{DataClass} object rather than a tibble or a list of tibbles.
Overrides \code{steps}.}

\item{verbose}{Logical, defaults to \code{TRUE}. Should verbose processing
messages and warnings be returned.}

\item{regions}{A character vector of target regions to be assigned to the
\code{target_regions} field and used to filter the returned data.}

\item{...}{Additional arguments to pass to class specific functionality.}
}
\value{
A tibble with data related to cases, deaths, hospitalisations,
recoveries and testing stratified by regions within the given country.
}
\description{
Provides an interface to source specific classes which
support regional level data. For simple use cases this allows downloading
clean, standardised, regional-level COVID-19 data sets. Internally this uses
the \code{DataClass()} parent class which allows documented downloading, cleaning,
and processing. Optionally all steps of data processing can be returned
along with the functions used for processing but by default just the
finalised processed data is returned. See the examples for some potential
use cases and the links to lower level functions for more details and
options.
}
\examples{
\dontrun{
# set up a data cache
start_using_memoise()

# download data for Italy
get_regional_data("italy")

# return totals for Italy with no localisation
get_regional_data("italy", localise = FALSE, totals = TRUE)

# download data for the UK but return the class
uk <- get_regional_data("United Kingdom", class = TRUE)
uk

# return UK data from the class object]
uk$return()
}
}
\seealso{
\code{\link[=Italy]{Italy()}}, \code{\link[=UK]{UK()}}

Data interface functions
\code{\link{CountryDataClass}},
\code{\link{DataClass}},
\code{\link{get_available_datasets}()},
\code{\link{get_national_data}()},
\code{\link{initialise_dataclass}()}
}
\concept{interface}
