% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covr.R
\name{file_coverage}
\alias{file_coverage}
\title{Calculate test coverage for sets of files}
\usage{
file_coverage(source_files, test_files, line_exclusions = NULL,
  function_exclusions = NULL, parent_env = parent.frame())
}
\arguments{
\item{source_files}{Character vector of source files with function
definitions to measure coverage}

\item{test_files}{Character vector of test files with code to test the
functions}

\item{line_exclusions}{a named list of files with the lines to exclude from
each file.}

\item{function_exclusions}{a vector of regular expressions matching function
names to exclude. Example \code{print\\.} to match print methods.}

\item{parent_env}{The parent environment to use when sourcing the files.}
}
\description{
The files in \code{source_files} are first sourced into a new environment
to define functions to be checked. Then they are instrumented to track
coverage and the files in \code{test_files} are sourced.
}

