% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/plot_grid.R
\name{plot_grid}
\alias{plot_grid}
\title{Arrange multiple plots into a grid}
\usage{
plot_grid(..., plotlist = NULL, align = c("none", "h", "v", "hv"),
  nrow = NULL, ncol = NULL, scale = 1, rel_widths = 1,
  rel_heights = 1, labels = NULL, label_size = 14, hjust = -0.5,
  vjust = 1.5, cols = NULL, rows = NULL)
}
\arguments{
\item{...}{List of plots to be arranged into the grid. The plots can be either ggplot2 plot objects
or arbitrary gtables.}

\item{plotlist}{(optional) List of plots to display. Alternatively, the plots can be provided
individually as the first n arguments of the function plot_grid (see examples).}

\item{align}{(optional) Specifies whether graphs in the grid should be horizontally ("h") or
vertically ("v") aligned. Options are "none" (default), "hv" (align in both directions), "h", and "v".}

\item{nrow}{(optional) Number of rows in the plot grid.}

\item{ncol}{(optional) Number of columns in the plot grid.}

\item{scale}{(optional) Allows to set an overall scaling of each sub-plot. Can be set separately for
each subplot, by giving a vector of scale values, or at once for all subplots,
by giving a single value.}

\item{rel_widths}{(optional) Numerical vector of relative columns widths. For example, in a two-column
grid, \code{rel_widths = c(2, 1)} would make the first column twice as wide as the
second column.}

\item{rel_heights}{(optional) Numerical vector of relative columns heights. Works just as
\code{rel_widths} does, but for rows rather than columns.}

\item{labels}{(optional) List of labels to be added to the plots. You can also set \code{labels="AUTO"} to
auto-generate upper-case labels or \code{labels="auto"} to auto-generate lower-case labels.}

\item{label_size}{(optional) Numerical value indicating the label size. Default is 14.}

\item{hjust}{Adjusts the horizontal position of each label. More negative values move the label further
to the rigth on the plot canvas. Default is -0.5.}

\item{vjust}{Adjusts the vertical position of each label. More positive values move the label further
down on the plot canvas. Default is 1.5.}

\item{cols}{Deprecated. Like \code{ncol}.}

\item{rows}{Deprecated. Like \code{nrow}.}
}
\description{
Arrange multiple plots into a grid.
}
\examples{
p1 <- qplot(1:10, 1:10)
p2 <- qplot(1:10, (1:10)^2)
p3 <- qplot(1:10, (1:10)^3)
p4 <- qplot(1:10, (1:10)^4)
# simple grid
plot_grid(p1, p2, p3, p4)
# simple grid with labels and aligned plots
plot_grid(p1, p2, p3, p4, labels=c('A', 'B', 'C', 'D'), align="hv")
# manually setting the number of rows, auto-generate upper-case labels
plot_grid(p1, p2, p3, nrow=3, labels="AUTO", label_size=12, align="v")
# missing plots in some grid locations, auto-generate lower-case labels
plot_grid(p1, NULL, NULL, p2, p3, NULL, ncol=2,
 labels="auto", label_size=12, align="v")
# making rows and columns of different widths/heights
plot_grid(p1, p2, p3, p4, align='hv', rel_heights=c(2,1), rel_widths=c(1,2))
}

