% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_detour.R
\name{get_detour}
\alias{get_detour}
\title{Return the nodes that can be reached in a detour time set around the shortest path}
\usage{
get_detour(Graph, from, to, extra = NULL, allcores = FALSE)
}
\arguments{
\item{Graph}{An object generated by cppRouting::makegraph() function.}

\item{from}{A vector of one or more vertices from which shortest path are calculated (origin).}

\item{to}{A vector of one or more vertices (destination).}

\item{extra}{numeric. Additional cost}

\item{allcores}{Logical. If TRUE, all cores are used.}
}
\value{
List of nodes that can be reached
}
\description{
Return the nodes that can be reached in a detour time set around the shortest path
}
\details{
Each returned nodes \emph{n} meet the following condition : \cr
 \strong{SP(o,n) + SP(n,d) < SP(o,d) + t} \cr
 with \emph{SP} shortest distance/time, \emph{o} the origin node, \emph{d} the destination node and \emph{t} the extra cost.

Modified bidirectional Dijkstra algorithm is ran for each path.
}
\note{
'from' and 'to' must be the same length.
}
\examples{
if(requireNamespace("igraph",quietly = TRUE)){

#Generate fully connected graph
gf<- igraph::make_full_graph(400)
igraph::V(gf)$names<-1:400

#Convert to data frame and add random weights
df<-igraph::as_long_data_frame(gf)
df$dist<-sample(1:100,nrow(df),replace = TRUE)

#Construct cppRouting graph
graph<-makegraph(df[,c(1,2,5)],directed = FALSE)

#Pick up random origin and destination node
origin<-sample(1:400,1)
destination<-sample(1:400,1)

#Compute distance from origin to all nodes
or_to_all<-get_distance_matrix(graph,from=origin,to=1:400,allcores=FALSE)

#Compute distance from all nodes to destination 
all_to_dest<-get_distance_matrix(graph,from=1:400,to=destination,allcores=FALSE)

#Get all shortest paths from origin to destination, passing by each node of the graph
total_paths<-rowSums(cbind(t(or_to_all),all_to_dest))

#Compute shortest path between origin and destination 
distance<-get_distance_pair(graph,from=origin,to=destination,allcores=FALSE)

#Compute detour with an additional cost of 3
det<-get_detour(graph,from=origin,to=destination,extra=3,allcores=FALSE)

#Check result validity
length(unlist(det))
length(total_paths[total_paths < distance + 3])

} 
}
