library(cpr)

################################################################################
# test that Influcnce is as expected for control polygon
bmat <- bsplines(x      = seq(0, 6, length = 500),
                 iknots = c(1.0, 1.5, 2.3, 4.0, 4.5))
theta <- c(1, 0, 3.5, 4.2, 3.7, -0.5, -0.7, 2, 1.5)
omit_xi <- influence_of(cp(bmat, theta), c(6, 8))
stopifnot(isTRUE(all.equal(omit_xi$weight$w[1], 0.5391355923)))   #sprintf("%.10f", omit_xi$weight$w[1])
stopifnot(isTRUE(all.equal(omit_xi$weight$w[2], 0.2775424520)))

################################################################################
# test that influence weights for control polygon is as expected
bmat <- bsplines(x      = seq(0, 6, length = 500),
                 iknots = c(1.0, 1.5, 2.3, 4.0, 4.5))
theta <- c(1, 0, 3.5, 4.2, 3.7, -0.5, -0.7, 2, 1.5)
iw <- influence_weights(cp(bmat, theta))
expected <- structure(list(iknots = c(1, 1.5, 2.3, 4, 4.5), w = c(1.28320371711094, 0.539135592305278, 0.558614618870046, 0.277542452002693, 0.647979474076723)), class = "data.frame", row.names = c(NA, -5L))
stopifnot(isTRUE(all.equal(iw, expected)))

################################################################################
# test that influence_weights for control net are as expected
initial_cn44 <- cn(log10(pdg) ~ btensor(list(day, age), df = list(24, 24)), data = spdg)
iw <- influence_weights(initial_cn44)

expected <-
  list(structure(list(iknots = c(-0.927941546989166, -0.864279864279864, -0.801587301587302, -0.733500417710944, -0.673959673959674, -0.606679035250464, -0.539154539154539, -0.472361459203564, -0.408850408850409, -0.347189042841217, -0.278624338624339, -0.214561500275786, -0.149823633156966, -0.084920634920635, -0.0338259441707718, 0.135786435786436, 0.3003663003663, 0.463003663003663, 0.645058023209284, 0.816829004329004)
                      , max_w = c(2.20716057270512, 2.08089753612485, 1.27994790254683, 0.839986320318741, 0.870404268939342, 1.19129143391542, 1.29067977639264, 0.873572057092875, 0.632736079632996, 0.726102116339379, 0.601514092805447, 0.398568429802977, 0.279993212159539, 0.547275122421305, 0.73253425664502, 1.12664314585208, 1.05521482442615, 0.863703465463413, 0.843797471998719, 0.794531543375414)
                     )
                , class = c("data.frame")
                , row.names = c(NA, -20L)
                )
     , structure(list(
                      iknots = c(46.5030784738986, 46.8052824384244, 47.054023071138,
                                 47.2646954701808, 47.5295600012368, 47.8056655622045, 48.0744195779572,
                                 48.2661275459597, 48.4468227265675, 48.7082506308525, 48.9395919576026,
                                 49.2058607415274, 49.4682069437421, 49.7185266265909, 49.9917820585667,
                                 50.290747632068, 50.6387555972685, 51.062128205358, 51.4597893882533,
                                 52.0037799690902)
                      , max_w = c(0.622589787427728,
                                 0.412242263673391, 0.465243745597644, 0.491436864174441,
                                 0.349877198858808, 0.204683837938161, 0.162911031114499,
                                 0.192974399799336, 0.238935766674498, 0.331156057062758,
                                 0.385613215140317, 0.448096962477517, 0.40302930046861, 0.315590048917218,
                                 0.249282186324913, 0.253656972568126, 0.260948477175003,
                                 0.421078875729129, 0.594208247442293, 0.88615763871374)
                      )
                 , class = c("data.frame")
                 , row.names = c(NA, -20L)
                 )
    )

stopifnot(isTRUE(all.equal(iw, expected)))


################################################################################
##                                End of File                                 ##
################################################################################
