% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitAndTestSurvival.R
\name{fitSurvival}
\alias{fitSurvival}
\title{Estimation of survival curves for each risk separately}
\usage{
fitSurvival(time, risk, group, cens = NULL, type = "kaplan-meier",
  conf.int = 0.95, conf.type = "log")
}
\arguments{
\item{time}{vector with times of the first event or follow-up, must be numeric.}

\item{risk}{vector with type of event, can be numeric or factor/character.}

\item{group}{vector with group variable, can be numeric or factor/character.}

\item{cens}{value of 'risk' indicating censored observation (if NULL, the first value of 'risk' vector will be taken).}

\item{type}{type of survival curve to be fitted. Possible values are "kaplan-meier" (default), "fleming-harrington" or "fh2".}

\item{conf.int}{level of two-sided confidence interval (default = 0.95).}

\item{conf.type}{type of confidence interval. Possible  values: "none", "plain", "log" (default), "log-log".}
}
\value{
List, which elements are survfit.summary objects from the package Survival for each risk separately.
}
\description{
Fits survival curves for each risk and group, treating other types of events as censoring.
}
\examples{
fitSurvival(time = LUAD$time, risk = LUAD$event, group = LUAD$gender, cens = "alive",
type = "kaplan-meier", conf.int = 0.95, conf.type = "log")
}
\seealso{
\code{\link[survival]{survfit}} \code{\link[survival]{summary.survfit}}
}
