% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_transformation.R
\name{time_transfer}
\alias{time_transfer}
\title{Time Format Transfering}
\usage{
time_transfer(dat, date_cols = "DATE$|time$|date$|timestamp$|stamp$",
  ex_cols = NULL, note = FALSE)
}
\arguments{
\item{dat}{A data frame}

\item{date_cols}{Names of time variable or regular expressions for finding time variables. Default is  "DATE$|time$|date$|timestamp$|stamp$".}

\item{ex_cols}{Names of excluded variables. Regular expressions can also be used to match variable names. Default is NULL.}

\item{note}{Logical, outputs info. Default is TRUE.}
}
\value{
A data.frame with transfermed time variables.
}
\description{
\code{time_transfer} is for transfering time variables to time format.
}
\examples{
#transfer a variable.
dat = time_transfer(dat = lendingclub,date_cols = "issue_d")
class(dat[,"issue_d"])
#transfer a group of variables with similar name.
dat = time_transfer(dat = lendingclub,date_cols = "_d$")
class(dat[,"issue_d"])
#transfer all time variables.
dat = time_transfer(dat = lendingclub,date_cols = NULL)
class(dat[,"issue_d"])
}
