% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crew_options_lsf.R
\name{crew_options_lsf}
\alias{crew_options_lsf}
\title{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} LSF options.}
\usage{
crew_options_lsf(
  verbose = FALSE,
  command_submit = as.character(Sys.which("bsub")),
  command_terminate = as.character(Sys.which("bkill")),
  script_directory = tempdir(),
  script_lines = character(0L),
  cwd = getwd(),
  log_output = "/dev/null",
  log_error = "/dev/null",
  memory_gigabytes_limit = NULL,
  memory_gigabytes_required = NULL,
  cores = NULL
)
}
\arguments{
\item{verbose}{Logical, whether to see console output and error messages
when submitting worker.}

\item{command_submit}{Character of length 1,
file path to the executable to submit a worker job.}

\item{command_terminate}{Character of length 1,
file path to the executable to terminate a worker job.
Set to \code{""} to skip manually terminating the worker.
Unless there is an issue with the platform,
the job should still exit thanks to the NNG-powered network programming
capabilities of \code{mirai}. Still, if you set \code{command_terminate = ""},
you are assuming extra responsibility for manually monitoring
your jobs on the cluster and manually terminating jobs as appropriate.}

\item{script_directory}{Character of length 1, directory path to the
job scripts. Just before each job submission, a job script
is created in this folder. Script base names are unique to each
launcher and worker, and the launcher deletes the script when the
worker is manually terminated. \code{tempdir()} is the default, but it
might not work for some systems.
\code{tools::R_user_dir("crew.cluster", which = "cache")}
is another reasonable choice.}

\item{script_lines}{Optional character vector of additional lines to be
added to the job script just after the more common flags.
An example would be \code{script_lines = "module load R"} if your cluster
supports R through an environment module.}

\item{cwd}{Character of length 1, directory to
launch the worker from (as opposed to
the system default). \code{cwd = "/home"} translates to a line of
\verb{#BSUB -cwd /home} in the LSF job script. \code{cwd = getwd()} is the
default, which launches workers from the current working directory.
Set \code{cwd = NULL} to omit this line from the job script.}

\item{log_output}{Character of length 1, file pattern to control
the locations of the LSF worker log files. By default, both standard
output and standard error go to the same file.
\code{log_output = "crew_log_\%J.log"} translates to a line of
\verb{#BSUB -o crew_log_\%J.log} in the LSF job script,
where \verb{\%J} is replaced by the job ID of the worker.
The default is \verb{/dev/null} to omit these logs.
Set \code{log_output = NULL} to omit this line from the job script.}

\item{log_error}{Character of length 1, file pattern for standard
error. \code{log_error = "crew_error_\%J.err"} translates to a line of
\verb{#BSUB -e crew_error_\%J.err} in the LSF job script,
where \verb{\%J} is replaced by the job ID of the worker.
The default is \verb{/dev/null} to omit these logs.
Set \code{log_error = NULL} to omit this line from the job script.}

\item{memory_gigabytes_limit}{Positive numeric scalar, memory
limit in gigabytes of the worker.
\code{memory_gigabytes_limit = 4}
translates to a line of \verb{#BSUB -M 4G}
in the LSF job script.
\code{memory_gigabytes_limit = NULL} omits this line.}

\item{memory_gigabytes_required}{Positive numeric scalar,
memory requirement in gigabytes.
\code{memory_gigabytes_required = 4}
translates to a line of \verb{#BSUB -R 'rusage[mem=4G]'}
in the LSF job script.
\code{memory_gigabytes_required = NULL} omits this line.}

\item{cores}{Optional positive integer scalar,
number of CPU cores for the worker.
\code{cores = 4} translates
to a line of \verb{#BSUB -n 4} in the LSF job script.
\code{cores = NULL} omits this line.}
}
\value{
A classed list of options.
}
\description{
Set options for LSF job management.
}
\section{Retryable options}{

Retryable options are deprecated in \code{crew.cluster} as of
2025-01-27 (version \verb{0.3.4}).
}

\section{Attribution}{

The template files at
\url{https://github.com/mschubert/clustermq/tree/master/inst}
informed the development of the \code{crew} launcher plugins in
\code{crew.cluster}, and we would like to thank
Michael Schubert for developing \code{clustermq} and releasing it under
the permissive Apache License 2.0.
See the \code{NOTICE} and \code{README.md} files in the \code{crew.cluster}
source code for additional attribution.
}

\examples{
  crew_options_lsf()
}
\seealso{
Other lsf: 
\code{\link{crew_class_launcher_lsf}},
\code{\link{crew_controller_lsf}()},
\code{\link{crew_launcher_lsf}()}
}
\concept{lsf}
