% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crew_schedule.R
\name{crew_schedule}
\alias{crew_schedule}
\title{Create a schedule for bookkeeping tasks.}
\usage{
crew_schedule(seconds_interval = 0.25)
}
\arguments{
\item{seconds_interval}{Number of seconds between throttled iterations
of task collection.}
}
\description{
Create an \code{R6} object to contain and manage task objects.
}
\details{
Not a user-side function. There are no examples. Please see
\code{\link[=crew_controller_local]{crew_controller_local()}} for details.
}
\examples{
if (identical(Sys.getenv("CREW_EXAMPLES"), "true")) {
schedule <- crew_schedule()
schedule$start()
schedule$push(task = mirai::mirai(1 + 1))
schedule$push(task = mirai::mirai(2 + 2))
Sys.sleep(4)
schedule$collect(throttle = FALSE)
schedule$pop()$data # numeric result
schedule$pop()$data # numeric result
schedule$pop()$data # NULL
}
}
\seealso{
Other developer: 
\code{\link{crew_client}()},
\code{\link{crew_controller}()},
\code{\link{crew_launcher}()}
}
\concept{developer}
