% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crew_worker.R
\name{crew_worker}
\alias{crew_worker}
\title{Crew worker.}
\usage{
crew_worker(
  settings,
  launcher,
  worker,
  options_metrics = crew::crew_options_metrics()
)
}
\arguments{
\item{settings}{Named list of arguments to \code{mirai::daemon()}.}

\item{launcher}{Character string, name of the launcher}

\item{worker}{Character of length 1 to uniquely identify the current worker.}

\item{options_metrics}{Either \code{NULL} to opt out of resource metric logging
for workers, or an object from \code{\link[=crew_options_metrics]{crew_options_metrics()}} to enable
and configure resource metric logging for workers.
For resource logging to run,
the \code{autometric} R package version 0.1.0 or higher
must be installed.}
}
\value{
\code{NULL} (invisibly)
}
\description{
Launches a \code{crew} worker which runs a \code{mirai} daemon.
Not a user-side function. Users should not call \code{\link[=crew_worker]{crew_worker()}}
directly. See launcher plugins like \code{\link[=crew_launcher_local]{crew_launcher_local()}}
for examples.
}
\seealso{
Other utility: 
\code{\link{crew_assert}()},
\code{\link{crew_clean}()},
\code{\link{crew_deprecate}()},
\code{\link{crew_eval}()},
\code{\link{crew_random_name}()},
\code{\link{crew_retry}()},
\code{\link{crew_terminate_process}()},
\code{\link{crew_terminate_signal}()}
}
\concept{utility}
