% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sch_topological_indicators.R
\name{sch_topoi_la}
\alias{sch_topoi_la}
\title{LA Length of Arcs Topological Indicator}
\usage{
sch_topoi_la(sch)
}
\arguments{
\item{sch}{A schedule object.}
}
\value{
A number between 0 and 1, inclusive.
}
\description{
Measures the presence of long arcs based on the difference between
the progressive level of the end activity and the start node
of each relation.
If LA is approximately equal zero, the progressive level between
activities is as far as possible.
Otherwise, if LA is equal one, the relation distance are one.
}
\examples{
sch <- sch_new() \%>\%
  sch_title("Fictitious Project Example") \%>\%
  sch_reference("VANHOUCKE, Mario. Measuring time:
  improving project performance using earned value management.
  Gent: Springer, 2009, p. 18") \%>\%
  sch_add_activity(  1L, "a1" , 0L, 2L,3L,4L) \%>\%
  sch_add_activity(  2L, "a2" , 4L, 5L) \%>\%
  sch_add_activity(  3L, "a3" , 9L, 10L) \%>\%
  sch_add_activity(  4L, "a4" , 1L, 6L) \%>\%
  sch_add_activity(  5L, "a5" , 4L, 9L) \%>\%
  sch_add_activity(  6L, "a6" , 5L, 7L) \%>\%
  sch_add_activity(  7L, "a7" , 1L, 8L,11L) \%>\%
  sch_add_activity(  8L, "a8" , 7L, 12L) \%>\%
  sch_add_activity(  9L, "a9" , 8L, 12L) \%>\%
  sch_add_activity( 10L, "a10", 3L, 12L) \%>\%
  sch_add_activity( 11L, "a11", 3L, 12L) \%>\%
  sch_add_activity( 12L, "a12", 0L) \%>\%
  sch_plan()
sch_topoi_la(sch) # 0.07692308

}
\seealso{
\code{\link[=sch_topoi_sp]{sch_topoi_sp()}}, \code{\link[=sch_add_relations]{sch_add_relations()}}, \code{\link[=sch_topoi_ad]{sch_topoi_ad()}},
\code{\link[=sch_relations]{sch_relations()}}, \code{\link[=sch_xy_gantt_matrix]{sch_xy_gantt_matrix()}}, \code{\link[=sch_activities]{sch_activities()}},
\code{\link[=sch_topoi_tf]{sch_topoi_tf()}}, \code{\link[=sch_add_activities]{sch_add_activities()}}.
}
